<?php

use yii\helpers\Html;
use kartik\detail\DetailView;
use kartik\grid\GridView;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\helpers\Json;

use backend\models\base\Grupo;
use backend\models\base\Genero;
use backend\models\base\Departamento;
use backend\models\base\Municipio;
use backend\models\base\Tipodocumento;
use backend\models\base\Religion;
use backend\models\base\Etnia;
use backend\models\base\Rh;
use backend\models\base\Eps;
use backend\models\base\Barrio;
use backend\models\base\Tipotercero;
use backend\models\base\Terceroestado;
use backend\models\base\Parentesco;


$this->title = $model->primer_nombre.' '.$model->segundo_nombre.' '.$model->primer_apellido.' '.$model->segundo_apellido;
$this->params['breadcrumbs'][] = ['label' => 'Terceros', 'url' => ['index']];
//$this->params['breadcrumbs'][] = $this->title;

$this->params['actions'][] = ['label' => 'Actualizar', 'url' => 'update', 'id' => $model->id, 'icon' => '<i class="far fa-pencil"></i>', 'class' => 'primary'];
$this->params['actions'][] = ['label' => 'Nuevo', 'url' => 'create', 'icon' => '<i class="far fa-plus"></i>', 'class' => 'success'];
$this->params['actions'][] = ['label' => 'Listar', 'url' => 'index', 'icon' => '<i class="far fa-bars"></i>', 'class' => 'purple'];
$this->params['actions'][] = ['label' => 'Hoja de Vida', 'url' => 'hojadevida', 'id' => $model->id, 'icon' => '<i class="far fa-file-pdf"></i>', 'class' => 'danger'];
$this->params['actions'][] = ['label' => 'Eliminar', 'url' => 'delete', 'id' => $model->id, 'icon' => '<i class="far fa-trash-alt"></i>', 'class' => 'danger'];


$this->registerCss("
.profile-photo {
    width: 140px;
    height: 140px;
    margin-right: 15px;
}

.pull-left {
    float: left;
}

.thumbnail-bg {
    display: block;
    background-image: url('/img/user-no-img-m.jpg');
    -webkit-background-size: cover;
    background-size: cover;
    position: absolute;
    background-position: center;
    background-repeat: no-repeat;
    height: 100%;
    width: 100%;
}

.profile-summary p {
    margin-bottom: 12px;
}

.profile-username {
    font-size: 20px;
    font-weight: bold;
    color: #2980B9;
    margin-top:10px;
    margin-bottom: 5px;
}

.profile-summary p {
    margin-bottom: 12px;
}





");

?>

<div class="container">

  <div class="tercero-view">

    <div class="row">

        <div class="profile-photo pull-left">
            <?= Html::img($model->foto ? '@web/uploads/thumbnail/lg-'.$model->foto : '@web/images/user.jpg', ['class'=>'img-thumbnail']); ?>
        </div>

        <div class="pull-left">

            <div class="profile-username"><?= Html::encode($model->nombre) ?></div>
            <p>
            <?= $model->generos->genero ?>,
            <span id="age">21</span> años<script>
                                            var birth_date = moment("16-02-2001", "DD-MM-YYYY");
                                            var age = moment().diff(birth_date, 'years', true);
                                            // age = birth_date.fromNow(1);
                                            // $('#age').html(age);
                                            // alert(age.substr(0, age.indexOf('.')));
                                            $('#age').html(parseInt(age));
                                            var today = moment("22-12-2022","DD-MM-YYYY");
                                            var next_birthday= moment([today.year(), birth_date.month(), birth_date.date()]);
                                            if(next_birthday.isBefore(today)){
                                                next_birthday= moment([today.year()+1, birth_date.month(), birth_date.date()]);
                                            }
                                        </script>
            </p>
            <p>
                <i class="fas fa-phone-alt"></i>
                <a href="#send-sms-modal" rel="tooltip" class="modal-trigger-send-message" data-type="sms" data-toggle="modal" data-original-title="Send SMS" data-phone="57123456" data-sender-id="26814" data-recipient-id="198690" data-recipient-type="Student" data-sender-type="admin">
                    123456 
                </a>
            </p>
            <p>
            <i class="icon-envelope list-icon"></i>
            <a href="#send-email-modal" rel="tooltip" class="modal-trigger-send-message" data-type="email" data-toggle="modal" data-original-title="Send Email" data-email="chris@gmail.com" data-sender-id="26814" data-recipient-id="198690" data-recipient-type="Student" data-sender-type="admin">
            chris@gmail.com </a>
            </p>
            <p id="class_payment_status_text">

            <span id="class_status_text">
                <?php 

                    $color = "default";
                    $estado = "";

                    if ($model->tipo_tercero==1) $color="success";
                    if ($model->tipo_tercero==2) $color="info";
                    if ($model->tipo_tercero==3) $color="warning";
                    if ($model->tipo_tercero==4) $color="danger"; 

                    if ($model->tipo_tercero==1)
                    {    
                        $estado = "<span class='label label-default'>";
                        $estado .= ($model->tipo_tercero==1) ? $model->estados->estado : 'No Aplica';
                        $estado .= "</span>";
                    }
                        
                    if (!isset($model->grupo))
                    {
                        $grupo =($model->tipo_tercero==1) ? Html::a('<span class="label label-danger">Sin Grupo</span>',['/academico/create', 'id' => $model->id]) : ''; 
                    }
                    else
                    {
                        $data = Grupo::findOne($model->Grupo);
                        $grupo ='<span class="label label-success">'.($data ? $data->grupo : 'Sin Grupo').'</span>';
                    } 

                    echo "<span class='label label-{$color}'>".$model->tipoterceros->tipo."</span>&nbsp;&nbsp;".$estado."&nbsp;&nbsp;".$grupo;
                ?>
            </span>

            <span id="payment_status_text">
            <a href="https://app.teachngo.com/payments/add/198690" class="status-icon-important delayed-payment clickable" rel="qtip" data-original-title="Overdue payments:  $ 120,00" data-hasqtip="5" aria-describedby="qtip-5"><i class="icon-warning-sign"></i> $ 120,00</a> </span>
            </p>


            
            <br>
        </div>
    </div>
<!--
-----------------------------

<div class="row-fluid profile-summary">
<div class="span8">
<div class="clearfix">
<div class="profile-photo pull-left">
<div class="thumbnail-bg" style="background-image: url(/avatars/pic014.png)" title="Cristobal hart"></div>
</div>
<div class="pull-left">
<div class="profile-username">Cristobal hart </div>
<p>
Male,
<span id="age">21</span> años<script>
                                var birth_date = moment("16-02-2001", "DD-MM-YYYY");
                                var age = moment().diff(birth_date, 'years', true);
                                // age = birth_date.fromNow(1);
                                // $('#age').html(age);
                                // alert(age.substr(0, age.indexOf('.')));
                                $('#age').html(parseInt(age));
                                var today = moment("22-12-2022","DD-MM-YYYY");
                                var next_birthday= moment([today.year(), birth_date.month(), birth_date.date()]);
                                if(next_birthday.isBefore(today)){
                                    next_birthday= moment([today.year()+1, birth_date.month(), birth_date.date()]);
                                }
                            </script>
</p>
<p>
<i class="icon-phone list-icon"></i>
<a href="#send-sms-modal" rel="tooltip" class="modal-trigger-send-message" data-type="sms" data-toggle="modal" data-original-title="Send SMS" data-phone="57123456" data-sender-id="26814" data-recipient-id="198690" data-recipient-type="Student" data-sender-type="admin">
123456 </a>
</p>
<p>
<i class="icon-envelope list-icon"></i>
<a href="#send-email-modal" rel="tooltip" class="modal-trigger-send-message" data-type="email" data-toggle="modal" data-original-title="Send Email" data-email="chris@gmail.com" data-sender-id="26814" data-recipient-id="198690" data-recipient-type="Student" data-sender-type="admin">
chris@gmail.com </a>
</p>
<p id="class_payment_status_text">

<span id="class_status_text">
<span class="status-icon-success" rel="qtip" data-add-class="text-center" data-original-title="Active<br/>Enrolled in 3 classes" data-hasqtip="4" aria-describedby="qtip-4"><i class="icon-ok-sign"></i>3</span> </span>

<span id="payment_status_text">
<a href="https://app.teachngo.com/payments/add/198690" class="status-icon-important delayed-payment clickable" rel="qtip" data-original-title="Overdue payments:  $ 120,00" data-hasqtip="5" aria-describedby="qtip-5"><i class="icon-warning-sign"></i> $ 120,00</a> </span>
</p>
</div>
</div>
</div>
<div class="span4">
</div>
</div>
    --------------------------------------------------------------------
-->
    <div class="row">
<?php 


    $color = "default";
    $estado = "";

    if ($model->tipo_tercero==1) $color="success";
    if ($model->tipo_tercero==2) $color="info";
    if ($model->tipo_tercero==3) $color="warning";
    if ($model->tipo_tercero==4) $color="danger"; 

    if ($model->tipo_tercero==1)
    {    
        $estado = "<span class='label label-default'>";
        $estado .= ($model->tipo_tercero==1) ? $model->estados->estado : 'No Aplica';
        $estado .= "</span>";
    }
        
    if (!isset($model->grupo))
    {
        $grupo =($model->tipo_tercero==1) ? Html::a('<span class="label label-danger">Sin Grupo</span>',['/academico/create', 'id' => $model->id]) : ''; 
    }
    else
    {
        $data = Grupo::findOne($model->Grupo);
        $grupo ='<span class="label label-success">'.($data ? $data->grupo : 'Sin Grupo').'</span>';
    } 

    $gridColumn = [
        [
            'group'=>true,
            'label'=>'Información Básica',
            'rowOptions'=>['class'=>'info']
        ],
        [
            'columns' => [
                [
                    'attribute' => 'identificacion',
                    'valueColOptions'=>['style'=>'width:30%'],
                ],
                [
                    'attribute'=>'tipo',
                    'value'=>$model->tipos->tipo,
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Tipodocumento::find()->asArray()->all(), 'id', 'tipo'),
                    ],
                ],
                
            ],
        ], 

        [    
            'columns' => [
                [
                    'attribute'=>'genero',
                    'value'=>$model->generos->genero,
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2,
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Genero::find()->asArray()->all(), 'id', 'genero'),
                    ],
                ], 
                [
                    'attribute' => 'tipo_tercero',
                    'label' => 'Tipo Tercero',
                    'format' => 'RAW',
                    'value' => "<span class='label label-{$color}'>".$model->tipoterceros->tipo."</span>&nbsp;&nbsp;".$estado."&nbsp;&nbsp;".$grupo,
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2,
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Tipotercero::find()->asArray()->all(), 'id', 'tipo'),
                    ],
                ],           
                
            ],
        ],
        [    
            'columns' => [ 
                
                [
                    'attribute'=>'fecha_nacimiento', 
                    'format'=>'date',
                    'type'=>DetailView::INPUT_DATE,
                    'widgetOptions' => [
                        'pluginOptions'=>['autoclose' => true,
                                          'format' => 'yyyy-mm-dd',
                                          'todayHighlight' => true]
                    ],
                    'valueColOptions'=>['style'=>'width:30%'],
                ],
                [
                    'attribute'=>'genero',
                    'value'=>$model->generos->genero,
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2,
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Genero::find()->asArray()->all(), 'id', 'genero')],
                    'valueColOptions'=>['style'=>'width:30%']
                ],
            ],
        ], 

        [    
            'columns' => [
                [
                    'attribute'=>'departamento_nacimiento',
                    'value'=> $model->departamento_nacimiento ? $model->departamentos->nombre : '',
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Departamento::find()->asArray()->all(), 'id', 'nombre'),
                    ],
                ],   
                [
                    'attribute'=>'municipio_nacimiento',
                    'value'=> $model->municipio_nacimiento ? $model->municipios->nombre : '',
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Municipio::find()->asArray()->all(), 'id', 'nombre'),
                    ],
                ],
            ],
        ],        
        [
            'group'=>true,
            'label'=>'Información Adicional',
            'rowOptions'=>['class'=>'warning']
        ],
        [    
            'columns' => [
                [
                    'attribute' => 'rh',
                    'value'=> $model->rh ? $model->rhs->rh : '',
                    'type'=>DetailView::INPUT_SELECT2,
                    'valueColOptions'=>['style'=>'width:30%'], 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Rh::find()->asArray()->all(), 'id', 'rh'),
                    ],
                ],    
                [
                    'attribute' => 'religion',
                    'label' => 'Religión',
                    'value' => $model->religion ? $model->religiones->religion : '',
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Religion::find()->asArray()->all(), 'id', 'religion'),
                    ],
                ],    
            ],
        ],
        [    
            'columns' => [
                [
                    'attribute' => 'etnia',
                    'value' => $model->etnia ? $model->etnias->etnia : '',
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Etnia::find()->asArray()->all(), 'id', 'etnia'),
                    ],
                ],
                [
                    'attribute' => 'eps',
                    'value' => $model->eps ? $model->epss->eps : '',
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Eps::find()->asArray()->all(), 'id', 'eps'),
                    ],
                ],
                
            ],
    ],    
    [
        'group'=>true,
        'label'=>'Información de Contácto',
        'rowOptions'=>['class'=>'success']
    ],
    [    
            'columns' => [
                [
                    'attribute' => 'direccion',
                    'valueColOptions'=>['style'=>'width:30%'],
                ],
                [
                    'attribute' => 'barrio',
                    'value' => $model->barrio ? $model->barrios->nombre : '',
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Barrio::find()->asArray()->all(), 'id', 'barrio'),
                    ],
                ],
            ],
    ], 
    [    
            'columns' => [
                [
                    'attribute' => 'fijo',
                    'valueColOptions'=>['style'=>'width:30%'],
                ],
                [
                    'attribute' => 'movil',
                    'valueColOptions'=>['style'=>'width:30%'],
                ],
                   
            ],
    ],
        [    
            'columns' => [
                'email:email', /*
                [
                    'attribute' => 'foto',
                    'valueColOptions'=>['style'=>'width:33%'],
                ],
                [
                    'attribute' => 'estado',
                    'valueColOptions'=>['style'=>'width:33%'],
                ],*/
            ],
    ],                  
 ];

    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn,
        'mode' => 'view',
        'enableEditMode' => false,
        'bordered' => true,
        'striped' => false,
        /*'panel' => [
            'heading' => '',
            'type' => DetailView::TYPE_SUCCESS,
        ],*/
        'condensed' => false,
        'responsive' => true,
        'hover' => true,
        'hAlign'=> 'center',
        'vAlign'=> 'center',
        'fadeDelay'=> '1000',
        'deleteOptions'=>[ // your ajax delete parameters
            //'params' => ['id' => 1000, 'kvdelete'=>true],
                'params' => ['custom_param'=>true],
                'url'=>['delete', 'id' => $model->id],
        ],
        'container' => ['id'=>'kv-demo'],
        'formOptions' => ['action' => Url::current(['#' => 'delete'])] // your action to delete
    ]);
?>
    </div>

    <div class="row">
<?php
if($providerAcademico->totalCount){
    $gridColumnAcademico = [
        ['class' => 'yii\grid\SerialColumn'],
            [
                'attribute' => 'estudiantes.primer_nombre',
                'label' => 'Estudiante'
        ],
            [
                'attribute' => 'grupos.grupo',
                'label' => 'Grupo'
        ],
            'fecha_matricula',
            'fecha_retiro',
            'aprobo',
            'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerAcademico,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-academico']],
        'panel' => [
        'type' => GridView::TYPE_PRIMARY,
        'heading' => '<span class="glyphicon glyphicon-book"></span> ' . Html::encode('Academico'.' '. $this->title),
        ],
        'columns' => $gridColumnAcademico
    ]);
}
?>
    </div>
 

 <div class="row">
<?php
if($providerAcudiente->totalCount){
    $gridColumnAcudiente = [
        ['class' => 'yii\grid\SerialColumn'],
            /*[
                'attribute' => 'estudiantes.nombre',
                'label' => 'Estudiante'
        ],*/
        [
            'attribute' => 'nombre',
            'label' => 'Nombres y Apellidos',
        ], 
        [
            'attribute' => 'identificacion',
            'label' => 'Cédula',
        ],    
           
            /*'primer_nombre',
            'segundo_nombre',
            'primer_apellido',
            'segundo_apellido',*/
            [
                'attribute' => 'generos.genero',
                'label' => 'Género'
        ],
            [
                'attribute' => 'parentescos.parentesco',
                'label' => 'Parentesco'
        ],
            [
                'attribute' => 'rhs.rh',
                'label' => 'RH'
        ],
            //'direccion',
            'fijo',
            'movil',
            //'email:email',
            //'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerAcudiente,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-acudiente']],
        'panel' => [
        'type' => GridView::TYPE_PRIMARY,
        'heading' => '<span class="fa fa-users"></span> ' . Html::encode('Acudientes de'.' '. $this->title),
        ],
        'export' => false,
        'columns' => $gridColumnAcudiente
    ]);
}
?>
    </div> 


    <div class="row">
<?php
if($providerAsistencia->totalCount){
    $gridColumnAsistencia = [
        ['class' => 'yii\grid\SerialColumn'],
            [
                'attribute' => 'asignaturas.asignatura',
                'label' => 'Asignatura'
        ],
            [
                'attribute' => 'grupos.grupo',
                'label' => 'Grupo'
        ],
            [
                'attribute' => 'periodos.periodo',
                'label' => 'Periodo'
        ],
            [
                'attribute' => 'directores.primer_nombre',
                'label' => 'Docente'
        ],
            [
                'attribute' => 'terceros.primer_nombre',
                'label' => 'Estudiante'
        ],
            'asistio',
            'fallas',
            [
                'attribute' => 'tipoInasistencias.tipo_inasistencia',
                'label' => 'Tipo Inasistencia'
        ],
            'fecha',
            'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerAsistencia,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-asistencia']],
        'panel' => [
        'type' => GridView::TYPE_PRIMARY,
        'heading' => '<span class="glyphicon glyphicon-book"></span> ' . Html::encode('Asistencia'.' '. $this->title),
        ],
        'columns' => $gridColumnAsistencia
    ]);
}
?>
    </div>
    

    <div class="row">
<?php
if($providerGrupo->totalCount){
    $gridColumnGrupo = [
        ['class' => 'yii\grid\SerialColumn'],
            [
                'attribute' => 'grados.grado',
                'label' => 'Grado'
        ],
            'grupo',
            [
                'attribute' => 'directores.primer_nombre',
                'label' => 'Director'
        ],
            [
                'attribute' => 'jornadas.jornada',
                'label' => 'Jornada'
        ],
            [
                'attribute' => 'sedes.sede',
                'label' => 'Sede'
        ],
            'por_nota',
            [
                'attribute' => 'metodologias.metodologia',
                'label' => 'Metodologia'
        ],
            [
                'attribute' => 'modalidades.modalidad',
                'label' => 'Modalidad'
        ],
            [
                'attribute' => 'especialidades.especialidad',
                'label' => 'Especialidad'
        ],
            'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerGrupo,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-grupo']],
        'panel' => [
        'type' => GridView::TYPE_PRIMARY,
        'heading' => '<span class="glyphicon glyphicon-book"></span> ' . Html::encode('Grupo'.' '. $this->title),
        ],
        'columns' => $gridColumnGrupo
    ]);
}
?>
    </div>

 <div class="row">
<?php
if($providerPlanAula->totalCount){
    $gridColumnPlanAula = [
        ['class' => 'yii\grid\SerialColumn'],
            [
                'attribute' => 'docentes.nombre',
                'label' => 'Docente'
        ],
            
            'semana_inicio',
            'semana_fin',
            [
                'attribute' => 'grados.grado',
                'label' => 'Grado'
        ],
            [
                'attribute' => 'asignaturas.asignatura',
                'label' => 'Asignatura'
        ],
            [
                'attribute' => 'grupos.grupo',
                'label' => 'Grupo'
        ],
            'estandar:ntext',
            [
                'attribute' => 'periodos.periodo',
                'label' => 'Periodo'
        ],
            [
                'attribute' => 'competencias.competencia',
                'label' => 'Competencia'
        ],
            'unidad',
            'nombre_unidad',
            'horas',
            'derechos:ntext',
            'inicio:ntext',
            'desarrollo:ntext',
            'cierre:ntext',
            'formativa:ntext',
            'articulacion:ntext',
            'recursos:ntext',
            'reflexion:ntext',
            'observaciones:ntext',
            'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerPlanAula,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-plan-aula']],
        'panel' => [
        'type' => GridView::TYPE_PRIMARY,
        'heading' => '<span class="glyphicon glyphicon-book"></span> ' . Html::encode('Plan Aula'.' '. $this->title),
        ],
        'columns' => $gridColumnPlanAula
    ]);
}
?>
    </div>     
  </div>
</div>