<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model backend\models\Tipocalificacion */
/* @var $form yii\widgets\ActiveForm */

\mootensai\components\JsBlock::widget(['viewFile' => '_script', 'pos'=> \yii\web\View::POS_END, 
    'viewParams' => [
        'class' => 'Desempeno', 
        'relID' => 'desempeno', 
        'value' => \yii\helpers\Json::encode($model->desempenos),
        'isNewRecord' => ($model->isNewRecord) ? 1 : 0
    ]
]);
\mootensai\components\JsBlock::widget(['viewFile' => '_script', 'pos'=> \yii\web\View::POS_END, 
    'viewParams' => [
        'class' => 'Grado', 
        'relID' => 'grado', 
        'value' => \yii\helpers\Json::encode($model->grados),
        'isNewRecord' => ($model->isNewRecord) ? 1 : 0
    ]
]);
?>

<div class="tipocalificacion-form">

    <?php $form = ActiveForm::begin(); ?>
    
    <?= $form->errorSummary($model); ?>

    <?= $form->field($model, 'tipo')->textInput(['maxlength' => true, 'placeholder' => 'Tipo']) ?>

    <?= $form->field($model, 'estado')->textInput(['placeholder' => 'Estado']) ?>

    <div class="form-group" id="add-desempeno"></div>

    <div class="form-group" id="add-grado"></div>

    <div class="form-group">
        <?= Html::submitButton($model->isNewRecord ? 'Create' : 'Update', ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
