<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Tipocalificacion */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Tipocalificacions', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="tipocalificacion-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= 'Tipocalificacion'.' '. Html::encode($this->title) ?></h2>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        'tipo',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]); 
?>
    </div>
    
    <div class="row">
<?php
    $gridColumnDesempeno = [
        ['class' => 'yii\grid\SerialColumn'],
        'desempeno',
        [
                'attribute' => 'tipoCalificacion.id',
                'label' => 'Tipo Calificacion'
        ],
        'limite_inferior',
        'limite_superior',
        'color',
        'nota',
        'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerDesempeno,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-desempeno']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => Html::encode('Desempeno'.' '. $this->title),
        ],
        'columns' => $gridColumnDesempeno
    ]);
?>
    </div>
    
    <div class="row">
<?php
    $gridColumnGrado = [
        ['class' => 'yii\grid\SerialColumn'],
        'grado',
        'codigo',
        [
                'attribute' => 'tipoCalificacion.id',
                'label' => 'Tipo Calificacion'
        ],
        'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerGrado,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-grado']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => Html::encode('Grado'.' '. $this->title),
        ],
        'columns' => $gridColumnGrado
    ]);
?>
    </div>
</div>
