<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\base\Tipocalificacion */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Tipocalificacions', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="tipocalificacion-view">

    <div class="row">
<?php 
    $gridColumn = [
        'tipo',
        [
                'attribute' => 'estado',
                'format' => 'RAW',
                'value' => ($model->estado == 1) ? '<span class="label label-success"><span class="glyphicon glyphicon-ok"></span> Activo</span>' : '<span class="label label-danger"><span class="glyphicon glyphicon-remove"></span> Inactivo</span>'
        ], 
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]); 
?>
    </div>
    
    <div class="row">
<?php
if($providerDesempeno->totalCount){
    $gridColumnDesempeno = [
        ['class' => 'yii\grid\SerialColumn'],
            'desempeno',
            [
                'attribute' => 'tipoCalificacion.id',
                'label' => 'Tipo Calificacion'
        ],
            'limite_inferior',
            'limite_superior',
            'color',
            'nota',
            [
                'attribute' => 'estado',
                'format' => 'RAW',
                'value' => ($model->estado == 1) ? '<span class="label label-success"><span class="glyphicon glyphicon-ok"></span> Activo</span>' : '<span class="label label-danger"><span class="glyphicon glyphicon-remove"></span> Inactivo</span>'
        ], 
    ];
    echo Gridview::widget([
        'dataProvider' => $providerDesempeno,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-desempeno']],
        'panel' => [
        'type' => GridView::TYPE_PRIMARY,
        'heading' => '<span class="glyphicon glyphicon-book"></span> ' . Html::encode('Desempeno'.' '. $this->title),
        ],
        'columns' => $gridColumnDesempeno
    ]);
}
?>
    </div>
</div>