<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\base\Tipocapacidad */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Tipocapacidads', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="tipocapacidad-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= 'Tipocapacidad'.' '. Html::encode($this->title) ?></h2>
        </div>
        <div class="col-sm-3" style="margin-top: 15px">
<?=             
             Html::a('<i class="fa glyphicon glyphicon-hand-up"></i> ' . 'PDF', 
                ['pdf', 'id' => $model->id],
                [
                    'class' => 'btn btn-danger',
                    'target' => '_blank',
                    'data-toggle' => 'tooltip',
                    'title' => 'Will open the generated PDF file in a new window'
                ]
            )?>
            
            <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
            <?= Html::a('Delete', ['delete', 'id' => $model->id], [
                'class' => 'btn btn-danger',
                'data' => [
                    'confirm' => 'Are you sure you want to delete this item?',
                    'method' => 'post',
                ],
            ])
            ?>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        ['attribute' => 'id', 'visible' => false],
        'tipo',
        'creado_el',
        'creado_por',
        'actualizado_el',
        'actualizado_por',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]); 
?>
    </div>
    
    <div class="row">
<?php
if($providerTercero->totalCount){
    $gridColumnTercero = [
        ['class' => 'yii\grid\SerialColumn'],
            ['attribute' => 'id', 'visible' => false],
            'identificacion',
            [
                'attribute' => 'tipo0.id',
                'label' => 'Tipo'
            ],
            'primer_nombre',
            'segundo_nombre',
            'primer_apellido',
            'segundo_apellido',
            [
                'attribute' => 'genero0.genero',
                'label' => 'Genero'
            ],
            [
                'attribute' => 'tipoTercero.id',
                'label' => 'Tipo Tercero'
            ],
            'fecha_nacimiento',
            [
                'attribute' => 'departamentoNacimiento.id',
                'label' => 'Departamento Nacimiento'
            ],
            [
                'attribute' => 'municipioNacimiento.id',
                'label' => 'Municipio Nacimiento'
            ],
            [
                'attribute' => 'rh0.rh',
                'label' => 'Rh'
            ],
            [
                'attribute' => 'religion0.religion',
                'label' => 'Religion'
            ],
            [
                'attribute' => 'etnia0.etnia',
                'label' => 'Etnia'
            ],
            [
                'attribute' => 'eps0.eps',
                'label' => 'Eps'
            ],
            'direccion',
            [
                'attribute' => 'barrio0.id',
                'label' => 'Barrio'
            ],
            'fijo',
            'movil',
            'email:email',
            'foto',
            [
                'attribute' => 'estrato0.estrato',
                'label' => 'Estrato'
            ],
            [
                'attribute' => 'situacion0.id',
                'label' => 'Situacion'
            ],
            'codigo_desplazado',
            [
                'attribute' => 'departamentoDesplazado.id',
                'label' => 'Departamento Desplazado'
            ],
            [
                'attribute' => 'municipioDesplazado.id',
                'label' => 'Municipio Desplazado'
            ],
            'codigo_sisben',
            'codigo_familia_accion',
                        'medicamentos',
            'alergias',
            'discapacidad',
            'discapacidad_certificada',
            'subsidio',
            [
                'attribute' => 'recurso0.id',
                'label' => 'Recurso'
            ],
            'bienestar',
            'heroe',
            'fuerza_publica',
            'sector',
            'resguardo',
            [
                'attribute' => 'departamentoResguardo.id',
                'label' => 'Departamento Resguardo'
            ],
            [
                'attribute' => 'municipioResguardo.id',
                'label' => 'Municipio Resguardo'
            ],
            'creado_el',
            'creado_por',
            'actualizado_el',
            'actualizado_por',
            'activo',
            [
                'attribute' => 'estado0.id',
                'label' => 'Estado'
            ],
    ];
    echo Gridview::widget([
        'dataProvider' => $providerTercero,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-tercero']],
        'panel' => [
        'type' => GridView::TYPE_PRIMARY,
        'heading' => '<span class="glyphicon glyphicon-book"></span> ' . Html::encode('Tercero'),
        ],
        'columns' => $gridColumnTercero
    ]);
}
?>
    </div>
</div>