<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use kartik\switchinput\SwitchInput;


/* @var $this yii\web\View */
/* @var $model backend\models\Tipocondicion */
/* @var $form yii\widgets\ActiveForm */

\mootensai\components\JsBlock::widget(['viewFile' => '_script', 'pos'=> \yii\web\View::POS_END, 
    'viewParams' => [
        'class' => 'CondicionPromocion', 
        'relID' => 'condicion-promocion', 
        'value' => \yii\helpers\Json::encode($model->condicionPromociones),
        'isNewRecord' => ($model->isNewRecord) ? 1 : 0
    ]
]);
?>

    <?php 

        $form = ActiveForm::begin([
            'validateOnSubmit' => true,
            'type' => ActiveForm::TYPE_VERTICAL,
            'options' => ['class' => 'main-task-form',
                            'id' => 'formulario',
                        ]
        ]); 
    ?>

<div class="tipocondicion-form">

<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> Información de Tipo de Condición</h3>
    </div>

    <div class="panel-body" >

            <?= $form->errorSummary($model); ?>

        <div class="col-sm-6">
            <?= $form->field($model, 'tipo')->textInput(['maxlength' => true, 'placeholder' => 'Tipo']) ?>
        </div>
        <div class="col-sm-6">
            <? ($model->isNewRecord) ? $model->estado = true: ''; ?>

            <?= $form->field($model, 'estado')->widget(SwitchInput::classname(), ['pluginOptions' => [
                'size' => 'medium',
                'onColor' => 'success',
                'offColor' => 'danger',
                'onText'=>'Activo',
                'offText'=>'Inactivo'
            ]]) 
            ?>
        </div>
    </div>

    <?php
    /*
    $forms = [
        [
            'label' => '<i class="glyphicon glyphicon-book"></i> ' . Html::encode(Yii::t('app', 'CondicionPromocion')),
            'content' => $this->render('_formCondicionPromocion', [
                'row' => \yii\helpers\ArrayHelper::toArray($model->condicionPromocions),
            ]),
        ],
    ];
    echo kartik\tabs\TabsX::widget([
        'items' => $forms,
        'position' => kartik\tabs\TabsX::POS_ABOVE,
        'encodeLabels' => false,
        'pluginOptions' => [
            'bordered' => true,
            'sideways' => true,
            'enableCache' => false,
        ],
    ]);
    */
    ?>
    
    <?php ActiveForm::end(); ?>

</div>
