<div class="form-group" id="add-condicion-promocion">
<?php
use kartik\grid\GridView;
use kartik\builder\TabularForm;
use yii\data\ArrayDataProvider;
use yii\helpers\Html;
use yii\widgets\Pjax;

$dataProvider = new ArrayDataProvider([
    'allModels' => $row,
    'pagination' => [
        'pageSize' => -1
    ]
]);
echo TabularForm::widget([
    'dataProvider' => $dataProvider,
    'formName' => 'CondicionPromocion',
    'checkboxColumn' => false,
    'actionColumn' => false,
    'attributeDefaults' => [
        'type' => TabularForm::INPUT_TEXT,
    ],
    'attributes' => [
        "id" => ['type' => TabularForm::INPUT_HIDDEN, 'columnOptions' => ['hidden'=>true]],
        'grado' => [
            'label' => 'Grado',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Grado::find()->orderBy('grado')->asArray()->all(), 'id', 'grado'),
                'options' => ['placeholder' => Yii::t('app', 'Choose Grado')],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'area' => [
            'label' => 'Area',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Area::find()->orderBy('area')->asArray()->all(), 'id', 'area'),
                'options' => ['placeholder' => Yii::t('app', 'Choose Area')],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'asignatura' => [
            'label' => 'Asignatura',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Asignatura::find()->orderBy('asignatura')->asArray()->all(), 'id', 'asignatura'),
                'options' => ['placeholder' => Yii::t('app', 'Choose Asignatura')],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'desempeno' => [
            'label' => 'Desempeno',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Desempeno::find()->orderBy('desempeno')->asArray()->all(), 'id', 'desempeno'),
                'options' => ['placeholder' => Yii::t('app', 'Choose Desempeno')],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'numero_areas' => ['type' => TabularForm::INPUT_TEXT],
        'numero_asignaturas' => ['type' => TabularForm::INPUT_TEXT],
        'numero_ausentismo' => ['type' => TabularForm::INPUT_TEXT],
        'descripcion' => ['type' => TabularForm::INPUT_TEXTAREA],
        'estado' => ['type' => TabularForm::INPUT_TEXT],
        'del' => [
            'type' => 'raw',
            'label' => '',
            'value' => function($model, $key) {
                return
                    Html::hiddenInput('Children[' . $key . '][id]', (!empty($model['id'])) ? $model['id'] : "") .
                    Html::a('<i class="glyphicon glyphicon-trash"></i>', '#', ['title' =>  Yii::t('app', 'Delete'), 'onClick' => 'delRowCondicionPromocion(' . $key . '); return false;', 'id' => 'condicion-promocion-del-btn']);
            },
        ],
    ],
    'gridSettings' => [
        'panel' => [
            'heading' => false,
            'type' => GridView::TYPE_DEFAULT,
            'before' => false,
            'footer' => false,
            'after' => Html::button('<i class="glyphicon glyphicon-plus"></i>' . Yii::t('app', 'Add Condicion Promocion'), ['type' => 'button', 'class' => 'btn btn-success kv-batch-create', 'onClick' => 'addRowCondicionPromocion()']),
        ]
    ]
]);
echo  "    </div>\n\n";
?>

