<?php

use yii\helpers\Html;
use kartik\detail\DetailView;
use kartik\grid\GridView;
use yii\helpers\Url;


/* @var $this yii\web\View */
/* @var $model backend\models\Tipocondicion */

$this->title = 'Tipo de Condición';
$this->params['breadcrumbs'][] = ['label' => 'Tipo de Condición', 'url' => ['index']];
$this->params['breadcrumbs'][] = 'Ver';

$this->params['actions'][] = ['label' => 'Actualizar', 'url' => 'update', 'id' => $model->id, 'icon' => '<i class="far fa-pencil"></i>', 'class' => 'primary'];
$this->params['actions'][] = ['label' => 'Nuevo', 'url' => 'create', 'icon' => '<i class="far fa-plus"></i>', 'class' => 'success'];
$this->params['actions'][] = ['label' => 'Listar', 'url' => 'index', 'icon' => '<i class="far fa-bars"></i>', 'class' => 'purple'];
$this->params['actions'][] = ['label' => 'PDF', 'url' => 'pdf', 'id' => $model->id, 'icon' => '<i class="far fa-file-pdf"></i>', 'class' => 'danger'];
$this->params['actions'][] = ['label' => 'Eliminar', 'url' => 'delete', 'id' => $model->id, 'icon' => '<i class="far fa-trash-alt"></i>', 'class' => 'danger'];

?>
<div class="tipocondicion-view">

    <div class="row">
<?php 
    $gridColumn = [
        [
            'columns' => [
                [
                    'attribute'=>'tipo',
                    'valueColOptions'=>['style'=>'width:80%'],
                ],
                
            ],
        ],
        [
            'columns' => [
                [
                    'attribute' => 'estado',
                    'format' => 'RAW',
                    'value' => ($model->estado == 1) ? '<span class="label label-success"><span class="glyphicon glyphicon-ok"></span> Activo</span>' : '<span class="label label-danger"><span class="glyphicon glyphicon-remove"></span> Inactivo</span>',
                    'valueColOptions'=>['style'=>'width:80%'],
                ],   
            ],
        ],
    ];
    
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn,
        'mode' => 'view',
        'enableEditMode' => false,
        'bordered' => true,
        'striped' => false,
        'panel' => [
            'heading' => 'Información Detallada',
            'type' => DetailView::TYPE_DEFAULT,
        ],
        'condensed' => false,
        'responsive' => true,
        'hover' => true,
        'hAlign'=> 'center',
        'vAlign'=> 'center',
        'fadeDelay'=> '1000',
        'deleteOptions'=>[ // your ajax delete parameters
            //'params' => ['id' => 1000, 'kvdelete'=>true],
                'params' => ['custom_param'=>true],
                'url'=>['delete', 'id' => $model->id],
        ],
        'container' => ['id'=>'kv-demo'],
        'formOptions' => ['action' => Url::current(['#' => 'delete'])] // your action to delete
    ]);
?>
    </div>
    
    <div class="row">
<?php
if($providerCondicionPromocion->totalCount){
    $gridColumnCondicionPromocion = [
        ['class' => 'yii\grid\SerialColumn'],
            ['attribute' => 'id', 'visible' => false],
                        [
                'attribute' => 'grados.grado',
                'label' => Yii::t('app', 'Grado')
            ],
            [
                'attribute' => 'areas.area',
                'label' => Yii::t('app', 'Area')
            ],
            [
                'attribute' => 'asignaturas.asignatura',
                'label' => Yii::t('app', 'Asignatura')
            ],
            [
                'attribute' => 'desempenos.desempeno',
                'label' => Yii::t('app', 'Desempeno')
            ],
            'numero_areas',
            'numero_asignaturas',
            'numero_ausentismo',
            'descripcion:ntext',
            'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerCondicionPromocion,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-condicion-promocion']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => '<span class="glyphicon glyphicon-book"></span> ' . Html::encode(Yii::t('app', 'Condicion Promocion')),
        ],
        'export' => false,
        'columns' => $gridColumnCondicionPromocion
    ]);
}
?>

    </div>
</div>
