<?php
use kartik\grid\GridView;
use yii\data\ArrayDataProvider;

    $dataProvider = new ArrayDataProvider([
        'allModels' => $model->asistencias,
        'key' => 'id'
    ]);
    $gridColumns = [
        ['class' => 'yii\grid\SerialColumn'],
        [
                'attribute' => 'asignatura.asignatura',
                'label' => 'Asignatura'
        ],
        [
                'attribute' => 'grupo.grupo',
                'label' => 'Grupo'
        ],
        [
                'attribute' => 'periodo.periodo',
                'label' => 'Periodo'
        ],
        [
                'attribute' => 'tercero.id',
                'label' => 'Docente'
        ],
        [
                'attribute' => 'tercero.id',
                'label' => 'Estudiante'
        ],
        'asistio',
        'fallas',
        'fecha',
        'estado',
        [
            'class' => 'yii\grid\ActionColumn',
            'controller' => 'asistencia'
        ],
    ];
    
    echo GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => $gridColumns,
        'containerOptions' => ['style' => 'overflow: auto'],
        'pjax' => true,
        'beforeHeader' => [
            [
                'options' => ['class' => 'skip-export']
            ]
        ],
        'export' => [
            'fontAwesome' => true
        ],
        'bordered' => true,
        'striped' => true,
        'condensed' => true,
        'responsive' => true,
        'hover' => true,
        'showPageSummary' => false,
        'persistResize' => false,
    ]);
