<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Tipoinasistencia */

$this->title = $model->tipo_inasistencia;
$this->params['breadcrumbs'][] = ['label' => 'Tipoinasistencias', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="tipoinasistencia-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= 'Tipoinasistencia'.' '. Html::encode($this->title) ?></h2>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        'tipo_inasistencia',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]); 
?>
    </div>
    
    <div class="row">
<?php
    $gridColumnAsistencia = [
        ['class' => 'yii\grid\SerialColumn'],
        [
                'attribute' => 'asignatura.asignatura',
                'label' => 'Asignatura'
        ],
        [
                'attribute' => 'grupo.grupo',
                'label' => 'Grupo'
        ],
        [
                'attribute' => 'periodo.periodo',
                'label' => 'Periodo'
        ],
        [
                'attribute' => 'tercero.id',
                'label' => 'Docente'
        ],
        [
                'attribute' => 'tercero.id',
                'label' => 'Estudiante'
        ],
        'asistio',
        'fallas',
        [
                'attribute' => 'tipoInasistencia.tipo_inasistencia',
                'label' => 'Tipo Inasistencia'
        ],
        'fecha',
        'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerAsistencia,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-asistencia']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => Html::encode('Asistencia'.' '. $this->title),
        ],
        'columns' => $gridColumnAsistencia
    ]);
?>
    </div>
</div>
