<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Tipoobservacion */

$this->title = $model->tipo_observacion;
$this->params['breadcrumbs'][] = ['label' => 'Tipoobservacions', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="tipoobservacion-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= 'Tipoobservacion'.' '. Html::encode($this->title) ?></h2>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        'tipo_observacion',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]); 
?>
    </div>
    
    <div class="row">
<?php
    $gridColumnObservacionFrd = [
        ['class' => 'yii\grid\SerialColumn'],
        [
                'attribute' => 'tipoObservacion.tipo_observacion',
                'label' => 'Tipo Observacion'
        ],
        [
                'attribute' => 'grado.grado',
                'label' => 'Grado'
        ],
        [
                'attribute' => 'asignatura.asignatura',
                'label' => 'Asignatura'
        ],
        [
                'attribute' => 'periodo.periodo',
                'label' => 'Periodo'
        ],
        [
                'attribute' => 'competencia.competencia',
                'label' => 'Competencia'
        ],
        'observacion:ntext',
        'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerObservacionFrd,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-observacion-frd']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => Html::encode('Observacion Frd'.' '. $this->title),
        ],
        'columns' => $gridColumnObservacionFrd
    ]);
?>
    </div>
</div>
