<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Tipoobservacion */

$this->title = $model->tipo_observacion;
$this->params['breadcrumbs'][] = ['label' => 'Tipoobservacions', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="tipoobservacion-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= 'Tipoobservacion'.' '. Html::encode($this->title) ?></h2>
        </div>
        <div class="col-sm-3" style="margin-top: 15px">
            <?=             
             Html::a('<i class="fa glyphicon glyphicon-hand-up"></i> ' . 'PDF', 
                ['pdf', 'id' => $model['id']],
                [
                    'class' => 'btn btn-danger',
                    'target' => '_blank',
                    'data-toggle' => 'tooltip',
                    'title' => 'Will open the generated PDF file in a new window'
                ]
            )?>                        
            <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
            <?= Html::a('Delete', ['delete', 'id' => $model->id], [
                'class' => 'btn btn-danger',
                'data' => [
                    'confirm' => 'Are you sure you want to delete this item?',
                    'method' => 'post',
                ],
            ])
            ?>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        'tipo_observacion',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]); 
?>
    </div>
    
    <div class="row">
<?php
if($providerObservacionFrd->totalCount){
    $gridColumnObservacionFrd = [
        ['class' => 'yii\grid\SerialColumn'],
            [
                'attribute' => 'tipoObservacion.tipo_observacion',
                'label' => 'Tipo Observacion'
        ],
            [
                'attribute' => 'grado.grado',
                'label' => 'Grado'
        ],
            [
                'attribute' => 'asignatura.asignatura',
                'label' => 'Asignatura'
        ],
            [
                'attribute' => 'periodo.periodo',
                'label' => 'Periodo'
        ],
            [
                'attribute' => 'competencia.competencia',
                'label' => 'Competencia'
        ],
            'observacion:ntext',
            'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerObservacionFrd,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-observacion-frd']],
        'panel' => [
        'type' => GridView::TYPE_PRIMARY,
        'heading' => '<span class="glyphicon glyphicon-book"></span> ' . Html::encode('Observacion Frd'.' '. $this->title),
        ],
        'columns' => $gridColumnObservacionFrd
    ]);
}
?>
    </div>
</div>