<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use kartik\switchinput\SwitchInput;
use kartik\widgets\ColorInput;
use kartik\widgets\DateTimePicker;
use kartik\widgets\Select2;
use kartik\widgets\FileInput;
use kartik\widgets\TouchSpin;
use dosamigos\tinymce\TinyMce;


?>

<?php $form = ActiveForm::begin([
    //'validateOnSubmit' => true,
    'type' => ActiveForm::TYPE_VERTICAL,
    'options' => ['class' => 'main-task-form',
                  'id' => 'formulario',
                  'enctype'=>'multipart/form-data',
                ]
]); ?>

<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> Tipo de PQRSD</h3>
    </div>

    <div class="panel-body" >

        <?= $form->errorSummary($model); ?>

        <?= $form->field($model, 'id', ['template' => '{input}'])->textInput(['style' => 'display:none']); ?>

        <div class="col-sm-9">
            <?= $form->field($model, 'tipo')->textInput(['maxlength' => true, 'placeholder' => 'Tipo']) ?>
        </div>       
        
        <div class="col-sm-3">             
            <?= $form->field($model, 'color')->widget(ColorInput::classname(), [
                 'options' => ['placeholder' => 'Seleccione el Color', 'readonly' => true],
                 'pluginOptions' => [
                        'allowClear' => true
                  ],
                ]);
        ?>
        </div>       
        
        <div class="col-sm-3">     
            <? ($model->isNewRecord) ? $model->estado = true: ''; ?>

            <?= $form->field($model, 'estado')->widget(SwitchInput::classname(), ['pluginOptions' => [
                'size' => 'medium',
                'onColor' => 'success',
                'offColor' => 'danger',
                'onText'=>'Activo',
                'offText'=>'Inactivo'
            ]]) 
            ?>
        </div>       
    
        <?php ActiveForm::end(); ?>
    </div>
</div>

