<div class="form-group" id="add-tercero">
<?php
use kartik\grid\GridView;
use kartik\builder\TabularForm;
use yii\data\ArrayDataProvider;
use yii\helpers\Html;
use yii\widgets\Pjax;

$dataProvider = new ArrayDataProvider([
    'allModels' => $row,
    'pagination' => [
        'pageSize' => -1
    ]
]);
echo TabularForm::widget([
    'dataProvider' => $dataProvider,
    'formName' => 'Tercero',
    'checkboxColumn' => false,
    'actionColumn' => false,
    'attributeDefaults' => [
        'type' => TabularForm::INPUT_TEXT,
    ],
    'attributes' => [
        "id" => ['type' => TabularForm::INPUT_HIDDEN, 'visible' => false],
        'identificacion' => ['type' => TabularForm::INPUT_TEXT],
        'tipo' => [
            'label' => 'Tipo documento',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\base\Tipodocumento::find()->orderBy('id')->asArray()->all(), 'id', 'id'),
                'options' => ['placeholder' => 'Choose Tipo documento'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'primer_nombre' => ['type' => TabularForm::INPUT_TEXT],
        'segundo_nombre' => ['type' => TabularForm::INPUT_TEXT],
        'primer_apellido' => ['type' => TabularForm::INPUT_TEXT],
        'segundo_apellido' => ['type' => TabularForm::INPUT_TEXT],
        'genero' => [
            'label' => 'Genero',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\base\Genero::find()->orderBy('genero')->asArray()->all(), 'id', 'genero'),
                'options' => ['placeholder' => 'Choose Genero'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'tipo_tercero' => [
            'label' => 'Tipo tercero',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\base\Tipotercero::find()->orderBy('id')->asArray()->all(), 'id', 'id'),
                'options' => ['placeholder' => 'Choose Tipo tercero'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'fecha_nacimiento' => ['type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\datecontrol\DateControl::classname(),
            'options' => [
                'type' => \kartik\datecontrol\DateControl::FORMAT_DATE,
                'saveFormat' => 'php:Y-m-d',
                'ajaxConversion' => true,
                'options' => [
                    'pluginOptions' => [
                        'placeholder' => 'Choose Fecha Nacimiento',
                        'autoclose' => true
                    ]
                ],
            ]
        ],
        'departamento_nacimiento' => [
            'label' => 'Departamento',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\base\Departamento::find()->orderBy('id')->asArray()->all(), 'id', 'id'),
                'options' => ['placeholder' => 'Choose Departamento'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'municipio_nacimiento' => [
            'label' => 'Municipio',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\base\Municipio::find()->orderBy('id')->asArray()->all(), 'id', 'id'),
                'options' => ['placeholder' => 'Choose Municipio'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'rh' => [
            'label' => 'Rh',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\base\Rh::find()->orderBy('rh')->asArray()->all(), 'id', 'rh'),
                'options' => ['placeholder' => 'Choose Rh'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'religion' => [
            'label' => 'Religion',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\base\Religion::find()->orderBy('religion')->asArray()->all(), 'id', 'religion'),
                'options' => ['placeholder' => 'Choose Religion'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'etnia' => [
            'label' => 'Etnia',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\base\Etnia::find()->orderBy('etnia')->asArray()->all(), 'id', 'etnia'),
                'options' => ['placeholder' => 'Choose Etnia'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'eps' => [
            'label' => 'Eps',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\base\Eps::find()->orderBy('eps')->asArray()->all(), 'id', 'eps'),
                'options' => ['placeholder' => 'Choose Eps'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'direccion' => ['type' => TabularForm::INPUT_TEXT],
        'barrio' => [
            'label' => 'Barrio',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\base\Barrio::find()->orderBy('id')->asArray()->all(), 'id', 'id'),
                'options' => ['placeholder' => 'Choose Barrio'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'fijo' => ['type' => TabularForm::INPUT_TEXT],
        'movil' => ['type' => TabularForm::INPUT_TEXT],
        'email' => ['type' => TabularForm::INPUT_TEXT],
        'foto' => ['type' => TabularForm::INPUT_TEXT],
        'estrato' => [
            'label' => 'Estrato',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\base\Estrato::find()->orderBy('estrato')->asArray()->all(), 'id', 'estrato'),
                'options' => ['placeholder' => 'Choose Estrato'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'situacion' => [
            'label' => 'Tipo situacion',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\base\Tiposituacion::find()->orderBy('id')->asArray()->all(), 'id', 'id'),
                'options' => ['placeholder' => 'Choose Tipo situacion'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'codigo_desplazado' => ['type' => TabularForm::INPUT_TEXT],
        'departamento_desplazado' => [
            'label' => 'Departamento',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\base\Departamento::find()->orderBy('id')->asArray()->all(), 'id', 'id'),
                'options' => ['placeholder' => 'Choose Departamento'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'municipio_desplazado' => [
            'label' => 'Municipio',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\base\Municipio::find()->orderBy('id')->asArray()->all(), 'id', 'id'),
                'options' => ['placeholder' => 'Choose Municipio'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'codigo_sisben' => ['type' => TabularForm::INPUT_TEXT],
        'codigo_familia_accion' => ['type' => TabularForm::INPUT_TEXT],
        'capacidad_excepcional' => ['type' => TabularForm::INPUT_TEXT],
        'medicamentos' => ['type' => TabularForm::INPUT_TEXT],
        'alergias' => ['type' => TabularForm::INPUT_TEXT],
        'discapacidad' => ['type' => TabularForm::INPUT_TEXT],
        'discapacidad_certificada' => ['type' => TabularForm::INPUT_TEXT],
        'subsidio' => ['type' => TabularForm::INPUT_TEXT],
        'bienestar' => ['type' => TabularForm::INPUT_TEXT],
        'heroe' => ['type' => TabularForm::INPUT_TEXT],
        'fuerza_publica' => ['type' => TabularForm::INPUT_TEXT],
        'sector' => ['type' => TabularForm::INPUT_TEXT],
        'resguardo' => ['type' => TabularForm::INPUT_TEXT],
        'departamento_resguardo' => [
            'label' => 'Departamento',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\base\Departamento::find()->orderBy('id')->asArray()->all(), 'id', 'id'),
                'options' => ['placeholder' => 'Choose Departamento'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'municipio_resguardo' => [
            'label' => 'Municipio',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\base\Municipio::find()->orderBy('id')->asArray()->all(), 'id', 'id'),
                'options' => ['placeholder' => 'Choose Municipio'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'creado_el' => ['type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\datecontrol\DateControl::classname(),
            'options' => [
                'type' => \kartik\datecontrol\DateControl::FORMAT_DATETIME,
                'saveFormat' => 'php:Y-m-d H:i:s',
                'ajaxConversion' => true,
                'options' => [
                    'pluginOptions' => [
                        'placeholder' => 'Choose Creado El',
                        'autoclose' => true,
                    ]
                ],
            ]
        ],
        'creado_por' => ['type' => TabularForm::INPUT_TEXT],
        'actualizado_el' => ['type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\datecontrol\DateControl::classname(),
            'options' => [
                'type' => \kartik\datecontrol\DateControl::FORMAT_DATETIME,
                'saveFormat' => 'php:Y-m-d H:i:s',
                'ajaxConversion' => true,
                'options' => [
                    'pluginOptions' => [
                        'placeholder' => 'Choose Actualizado El',
                        'autoclose' => true,
                    ]
                ],
            ]
        ],
        'actualizado_por' => ['type' => TabularForm::INPUT_TEXT],
        'activo' => ['type' => TabularForm::INPUT_TEXT],
        'estado' => [
            'label' => 'Tercero estado',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\base\TerceroEstado::find()->orderBy('id')->asArray()->all(), 'id', 'id'),
                'options' => ['placeholder' => 'Choose Tercero estado'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'del' => [
            'type' => 'raw',
            'label' => '',
            'value' => function($model, $key) {
                return Html::a('<i class="glyphicon glyphicon-trash"></i>', '#', ['title' =>  'Delete', 'onClick' => 'delRowTercero(' . $key . '); return false;', 'id' => 'tercero-del-btn']);
            },
        ],
    ],
    'gridSettings' => [
        'panel' => [
            'heading' => false,
            'type' => GridView::TYPE_DEFAULT,
            'before' => false,
            'footer' => false,
            'after' => Html::button('<i class="glyphicon glyphicon-plus"></i>' . 'Add Tercero', ['type' => 'button', 'class' => 'btn btn-success kv-batch-create', 'onClick' => 'addRowTercero()']),
        ]
    ]
]);
echo  "    </div>\n\n";
?>

