<?php
use kartik\grid\GridView;
use yii\data\ArrayDataProvider;

    $dataProvider = new ArrayDataProvider([
        'allModels' => $model->terceros,
        'key' => 'id'
    ]);
    $gridColumns = [
        ['class' => 'yii\grid\SerialColumn'],
        ['attribute' => 'id', 'visible' => false],
        'identificacion',
        [
                'attribute' => 'tipo0.id',
                'label' => 'Tipo'
            ],
        [
                'attribute' => 'departamentoExpedido.id',
                'label' => 'Departamento Expedido'
            ],
        [
                'attribute' => 'municipioExpedido.id',
                'label' => 'Municipio Expedido'
            ],
        'primer_nombre',
        'segundo_nombre',
        'primer_apellido',
        'segundo_apellido',
        [
                'attribute' => 'genero0.genero',
                'label' => 'Genero'
            ],
        [
                'attribute' => 'tipoTercero.id',
                'label' => 'Tipo Tercero'
            ],
        'fecha_nacimiento',
        [
                'attribute' => 'departamentoNacimiento.id',
                'label' => 'Departamento Nacimiento'
            ],
        [
                'attribute' => 'municipioNacimiento.id',
                'label' => 'Municipio Nacimiento'
            ],
        'pais',
        [
                'attribute' => 'rh0.rh',
                'label' => 'Rh'
            ],
        [
                'attribute' => 'religion0.religion',
                'label' => 'Religion'
            ],
        [
                'attribute' => 'etnia0.etnia',
                'label' => 'Etnia'
            ],
        [
                'attribute' => 'eps0.eps',
                'label' => 'Eps'
            ],
        'direccion',
        [
                'attribute' => 'departamentoResidencia.id',
                'label' => 'Departamento Residencia'
            ],
        [
                'attribute' => 'municipioResidencia.id',
                'label' => 'Municipio Residencia'
            ],
        [
                'attribute' => 'barrio0.id',
                'label' => 'Barrio'
            ],
        'fijo',
        'movil',
        'email:email',
        'foto',
        'firma',
        [
                'attribute' => 'estrato0.estrato',
                'label' => 'Estrato'
            ],
        [
                'attribute' => 'situacion0.id',
                'label' => 'Situacion'
            ],
        'codigo_desplazado',
        [
                'attribute' => 'departamentoDesplazado.id',
                'label' => 'Departamento Desplazado'
            ],
        [
                'attribute' => 'municipioDesplazado.id',
                'label' => 'Municipio Desplazado'
            ],
        'codigo_familia_accion',
        [
                'attribute' => 'capacidad0.id',
                'label' => 'Capacidad'
            ],
        'medicamentos',
        'alergias',
        'discapacidad',
        'discapacidad_certificada',
        'subsidio',
        [
                'attribute' => 'recurso0.id',
                'label' => 'Recurso'
            ],
        'bienestar',
        'heroe',
        'fuerza_publica',
        'sector',
        [
                'attribute' => 'resguardo0.resguardo',
                'label' => 'Resguardo'
            ],
        [
                'attribute' => 'departamentoResguardo.id',
                'label' => 'Departamento Resguardo'
            ],
        'cabeza_familia',
        'activo',
        [
                'attribute' => 'estado0.id',
                'label' => 'Estado'
            ],
        'bloqueo',
        [
            'class' => 'yii\grid\ActionColumn',
            'controller' => 'tercero'
        ],
    ];
    
    echo GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => $gridColumns,
        'containerOptions' => ['style' => 'overflow: auto'],
        'pjax' => true,
        'beforeHeader' => [
            [
                'options' => ['class' => 'skip-export']
            ]
        ],
        'export' => [
            'fontAwesome' => true
        ],
        'bordered' => true,
        'striped' => true,
        'condensed' => true,
        'responsive' => true,
        'hover' => true,
        'showPageSummary' => false,
        'persistResize' => false,
    ]);
