<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model app\models\Tiposisben */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Tiposisben', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="tiposisben-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= 'Tiposisben'.' '. Html::encode($this->title) ?></h2>
        </div>
        <div class="col-sm-3" style="margin-top: 15px">
            
            <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
            <?= Html::a('Delete', ['delete', 'id' => $model->id], [
                'class' => 'btn btn-danger',
                'data' => [
                    'confirm' => 'Are you sure you want to delete this item?',
                    'method' => 'post',
                ],
            ])
            ?>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        ['attribute' => 'id', 'visible' => false],
        'tipo',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]);
?>
    </div>
    
    <div class="row">
<?php
if($providerTercero->totalCount){
    $gridColumnTercero = [
        ['class' => 'yii\grid\SerialColumn'],
            ['attribute' => 'id', 'visible' => false],
            'identificacion',
            [
                'attribute' => 'tipo0.id',
                'label' => 'Tipo'
            ],
            [
                'attribute' => 'departamentoExpedido.id',
                'label' => 'Departamento Expedido'
            ],
            [
                'attribute' => 'municipioExpedido.id',
                'label' => 'Municipio Expedido'
            ],
            'primer_nombre',
            'segundo_nombre',
            'primer_apellido',
            'segundo_apellido',
            [
                'attribute' => 'genero0.genero',
                'label' => 'Genero'
            ],
            [
                'attribute' => 'tipoTercero.id',
                'label' => 'Tipo Tercero'
            ],
            'fecha_nacimiento',
            [
                'attribute' => 'departamentoNacimiento.id',
                'label' => 'Departamento Nacimiento'
            ],
            [
                'attribute' => 'municipioNacimiento.id',
                'label' => 'Municipio Nacimiento'
            ],
            'pais',
            [
                'attribute' => 'rh0.rh',
                'label' => 'Rh'
            ],
            [
                'attribute' => 'religion0.religion',
                'label' => 'Religion'
            ],
            [
                'attribute' => 'etnia0.etnia',
                'label' => 'Etnia'
            ],
            [
                'attribute' => 'eps0.eps',
                'label' => 'Eps'
            ],
            'direccion',
            [
                'attribute' => 'departamentoResidencia.id',
                'label' => 'Departamento Residencia'
            ],
            [
                'attribute' => 'municipioResidencia.id',
                'label' => 'Municipio Residencia'
            ],
            [
                'attribute' => 'barrio0.id',
                'label' => 'Barrio'
            ],
            'fijo',
            'movil',
            'email:email',
            'foto',
            'firma',
            [
                'attribute' => 'estrato0.estrato',
                'label' => 'Estrato'
            ],
            [
                'attribute' => 'situacion0.id',
                'label' => 'Situacion'
            ],
            'codigo_desplazado',
            [
                'attribute' => 'departamentoDesplazado.id',
                'label' => 'Departamento Desplazado'
            ],
            [
                'attribute' => 'municipioDesplazado.id',
                'label' => 'Municipio Desplazado'
            ],
                        'codigo_familia_accion',
            [
                'attribute' => 'capacidad0.id',
                'label' => 'Capacidad'
            ],
            'medicamentos',
            'alergias',
            'discapacidad',
            'discapacidad_certificada',
            'subsidio',
            [
                'attribute' => 'recurso0.id',
                'label' => 'Recurso'
            ],
            'bienestar',
            'heroe',
            'fuerza_publica',
            'sector',
            [
                'attribute' => 'resguardo0.resguardo',
                'label' => 'Resguardo'
            ],
            [
                'attribute' => 'departamentoResguardo.id',
                'label' => 'Departamento Resguardo'
            ],
            'cabeza_familia',
            'activo',
            [
                'attribute' => 'estado0.id',
                'label' => 'Estado'
            ],
            'bloqueo',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerTercero,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-tercero']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => '<span class="glyphicon glyphicon-book"></span> ' . Html::encode('Tercero'),
        ],
        'export' => false,
        'columns' => $gridColumnTercero
    ]);
}
?>

    </div>
</div>
