<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Tipotarea */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Tipotarea'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="tipotarea-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= Yii::t('app', 'Tipotarea').' '. Html::encode($this->title) ?></h2>
        </div>
        <div class="col-sm-3" style="margin-top: 15px">
            
            <?= Html::a(Yii::t('app', 'Update'), ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
            <?= Html::a(Yii::t('app', 'Delete'), ['delete', 'id' => $model->id], [
                'class' => 'btn btn-danger',
                'data' => [
                    'confirm' => Yii::t('app', 'Are you sure you want to delete this item?'),
                    'method' => 'post',
                ],
            ])
            ?>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        ['attribute' => 'id', 'visible' => false],
        'tipo',
        'color',
        'descripcion:ntext',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]);
?>
    </div>
    
    <div class="row">
<?php
if($providerTarea->totalCount){
    $gridColumnTarea = [
        ['class' => 'yii\grid\SerialColumn'],
            ['attribute' => 'id', 'visible' => false],
            'aid',
            [
                'attribute' => 'docente0.id',
                'label' => Yii::t('app', 'Docente')
            ],
            'estudiante',
            [
                'attribute' => 'asignatura0.asignatura',
                'label' => Yii::t('app', 'Asignatura')
            ],
            [
                'attribute' => 'grupo0.grupo',
                'label' => Yii::t('app', 'Grupo')
            ],
            [
                'attribute' => 'periodo0.periodo',
                'label' => Yii::t('app', 'Periodo')
            ],
            'tarea',
                        'descripcion:ntext',
            'adjunto:ntext',
            'disponible_desde',
            'disponible_hasta',
            'disponible_desde_2',
            'disponible_hasta_2',
            'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerTarea,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-tarea']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => '<span class="glyphicon glyphicon-book"></span> ' . Html::encode(Yii::t('app', 'Tarea')),
        ],
        'export' => false,
        'columns' => $gridColumnTarea
    ]);
}
?>

    </div>
</div>
