<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Tipotercero */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Tipoterceros', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="tipotercero-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= 'Tipotercero'.' '. Html::encode($this->title) ?></h2>
        </div>
        <div class="col-sm-3" style="margin-top: 15px">
            <?=             
             Html::a('<i class="fa glyphicon glyphicon-hand-up"></i> ' . 'PDF', 
                ['pdf', 'id' => $model['id']],
                [
                    'class' => 'btn btn-danger',
                    'target' => '_blank',
                    'data-toggle' => 'tooltip',
                    'title' => 'Will open the generated PDF file in a new window'
                ]
            )?>                        
            <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
            <?= Html::a('Delete', ['delete', 'id' => $model->id], [
                'class' => 'btn btn-danger',
                'data' => [
                    'confirm' => 'Are you sure you want to delete this item?',
                    'method' => 'post',
                ],
            ])
            ?>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        'tipo',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]); 
?>
    </div>
    
    <div class="row">
<?php
if($providerTercero->totalCount){
    $gridColumnTercero = [
        ['class' => 'yii\grid\SerialColumn'],
            'identificacion',
            [
                'attribute' => 'tipos.tipo',
                'label' => 'Tipo'
        ],
            'primer_nombre',
            'segundo_nombre',
            'primer_apellido',
            'segundo_apellido',
            [
                'attribute' => 'genero.genero',
                'label' => 'Genero'
        ],
            [
                'attribute' => 'tipoTercero.id',
                'label' => 'Tipo Tercero'
        ],
            [
                'attribute' => 'parentesco.parentesco',
                'label' => 'Parentesto'
        ],
            'fecha_nacimiento',
            [
                'attribute' => 'departamento.id',
                'label' => 'Departamento Nacimiento'
        ],
            [
                'attribute' => 'municipio.id',
                'label' => 'Municipio Nacimiento'
        ],
            [
                'attribute' => 'rh.rh',
                'label' => 'Rh'
        ],
            [
                'attribute' => 'religion.religion',
                'label' => 'Religion'
        ],
            [
                'attribute' => 'etnia.etnia',
                'label' => 'Etnia'
        ],
            [
                'attribute' => 'epss.eps',
                'label' => 'Eps'
        ],
            'direccion',
            [
                'attribute' => 'barrio.id',
                'label' => 'Barrio'
        ],
            'fijo',
            'movil',
            'email:email',
            'foto',
            'acudiente',
            'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerTercero,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-tercero']],
        'panel' => [
        'type' => GridView::TYPE_PRIMARY,
        'heading' => '<span class="glyphicon glyphicon-book"></span> ' . Html::encode('Tercero'.' '. $this->title),
        ],
        'columns' => $gridColumnTercero
    ]);
}
?>
    </div>
</div>