<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use kartik\password\PasswordInput;


?>

<div class="user-form">

    <?php $form = ActiveForm::begin([
            'validateOnSubmit' => true,
            'enableAjaxValidation' => true,
            'type' => ActiveForm::TYPE_VERTICAL,
            'options' => ['class' => 'main-task-form',
                            'id' => 'formulario',
                        ]
        ]); ?>

    <div class="row">
        <div class="col-sm-2 hidden-xs">
            <?= Html::img('@web/images/sonic-hero.png', ['class'=>'img-responsive hidden-xs animated bounceInUp','style' => 'position:fixed; z-index:0;']); ?>
        </div> 
        <div class="col-sm-10 col-xs-12">
    
            <div class="col-sm-12">
                <?= $form->field($model, 'oldPassword')->widget(PasswordInput::classname(), ['pluginOptions' => ['showMeter' => false]]); ?>
            </div>
        
            <div class="col-sm-12">
                <?= $form->field($model, 'newPassword')->widget(PasswordInput::classname(), ['pluginOptions' => [
                        'verdictTitles' => [
                            0 => 'No Establecido',
                            1 => 'Muy Débil',
                            2 => 'Débil',
                            3 => 'Buena', 
                            4 => 'Fuerte',
                            5 => 'Muy Fuerte'
                        ],
                    ]]); ?>
            </div>
        
            <div class="col-sm-12">
                <?= $form->field($model, 'retypePassword')->widget(PasswordInput::classname(), ['pluginOptions' => [
                        'verdictTitles' => [
                            0 => 'No Establecido',
                            1 => 'Muy Débil',
                            2 => 'Débil',
                            3 => 'Buena', 
                            4 => 'Fuerte',
                            5 => 'Muy Fuerte'
                        ],
                    ]]); ?>
            </div>
            <div class="col-sm-12">
                <?= Html::submitButton('Cambiar Contraseña', ['class' => 'btn btn-success']) ?>
            </div>
        </div>       
    </div>
    
    <?php ActiveForm::end(); ?>

</div>
