/*!
 * @package   yii2-grid
 * @author    Kartik Visweswaran <kartikv2@gmail.com>
 * @copyright Copyright &copy; Kartik Visweswaran, Krajee.com, 2014 - 2021
 * @version   3.3.6
 *
 * Grid Export Validation Module for Yii's Gridview. Supports export of
 * grid data as CSV, HTML, or Excel.
 *
 * Author: Kartik Visweswaran
 * Copyright: 2014 - 2021, Kartik Visweswaran, Krajee.com
 * For more JQuery plugins visit http://plugins.krajee.com
 * For more Yii related demos visit http://demos.krajee.com
 */!function(e){"use strict";var t,o,n="urn:schemas-microsoft-com:office:",r="http://www.w3.org/TR/REC-html40";t={replaceAll:function(e,t,o){return e.split(t).join(o)},isEmpty:function(t,o){return null===t||void 0===t||0===t.length||o&&""===e.trim(t)},popupDialog:function(e,t,o,n){var r=screen.width/2-o/2,i=60,a=window.open("",t,"",!0);return a.close(),window.open(e,t,"toolbar=no, location=no, directories=no, status=yes, menubar=no, scrollbars=no, resizable=no, copyhistory=no, width="+o+", height="+n+", top="+i+", left="+r)},slug:function(e){return e.toLowerCase().replace(/[^\w ]+/g,"").replace(/ +/g,"-")},templates:{html:'<!DOCTYPE html><meta http-equiv="Content-Type" content="text/html;charset={encoding}"/><meta http-equiv="X-UA-Compatible" content="IE=edge;chrome=1"/>{css}<style>.kv-wrap{padding:20px}</style><body class="kv-wrap">{data}</body>',pdf:"{before}\n{data}\n{after}",excel:'<html xmlns:o="'+n+'office" xmlns:x="'+n+'excel" xmlns="'+r+'"><head><meta http-equiv="Content-Type" content="text/html;charset={encoding}"/>{css}<!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>{worksheet}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--></head><body>{data}</body></html>',popup:'<html style="display:table;width:100%;height:100%;"><title>Grid Export - &copy; Krajee</title><body style="display:table-cell;font-family:Helvetica,Arial,sans-serif;color:#888;font-weight:bold;line-height:1.4em;text-align:center;vertical-align:middle;width:100%;height:100%;padding:0 10px;">{msg}</body></html>'}},o=function(t,o){var n=this,r=o.gridOpts,i=o.genOpts;n.$element=e(t),n.gridId=r.gridId,n.$grid=e("#"+n.gridId),n.dialogLib=o.dialogLib,n.messages=r.messages,n.target=r.target,n.exportConversions=r.exportConversions,n.skipExportElements=r.skipExportElements,n.showConfirmAlert=r.showConfirmAlert,n.action=r.action,n.bom=r.bom,n.encoding=r.encoding,n.module=r.module,n.filename=i.filename,n.expHash=i.expHash,n.showHeader=i.showHeader,n.showFooter=i.showFooter,n.showPageSummary=i.showPageSummary,n.$table=n.$grid.find(".kv-grid-table:first"),n.columns=n.showHeader?"td,th":"td",n.alertMsg=o.alertMsg,n.config=o.config,n.popup="",n.listen()},o.prototype={constructor:o,getArray:function(o){var n=this,r=n.clean(o),i=[],a={};return void 0!==n.config.colHeads&&n.config.colHeads.length>0?i=n.config.colHeads:r.find("thead tr th").each(function(o){var r=e(this).text().trim(),a=t.slug(r);i[o]=!n.config.slugColHeads||t.isEmpty(a)?"col_"+o:a}),r.find('tbody tr:has("td")').each(function(t){a[t]={},e(this).children("td").each(function(o){var n=i[o];a[t][n]=e(this).text().trim()})}),a},setPopupAlert:function(e){var o=this;if(void 0!==o.popup.document)if(arguments.length&&arguments[1]){var n=o.popup.document.getElementsByTagName("body");setTimeout(function(){n[0].innerHTML=e},1200)}else{var r=t.templates.popup.replace("{msg}",e);o.popup.document.write(r)}},processExport:function(e,o){var n=this;setTimeout(function(){t.isEmpty(o)?n[e]():n[e](o)},100)},listenClick:function(e){var o=this,n=arguments.length>1?arguments[1]:"",r=window[o.dialogLib];o.$element.off("click.gridexport").on("click.gridexport",function(i){if(i.stopPropagation(),i.preventDefault(),!o.showConfirmAlert)return void o.processExport(e,n);var a=o.messages,s=t.isEmpty(o.alertMsg)?"":o.alertMsg,l=t.isEmpty(a.allowPopups)?"":a.allowPopups,c=t.isEmpty(a.confirmDownload)?"":a.confirmDownload,p="";return p=s.length&&l.length?s+"\n\n"+l:!s.length&&l.length?l:s.length&&!l.length?s:"",c.length&&(p=p+"\n\n"+c),t.isEmpty(p)?void 0:(r.confirm(p,function(t){t&&o.processExport(e,n),i.preventDefault()}),!1)})},listen:function(){var e=this;e.$element.hasClass("export-csv")&&e.listenClick("exportTEXT","csv"),e.$element.hasClass("export-txt")&&e.listenClick("exportTEXT","txt"),e.$element.hasClass("export-html")&&e.listenClick("exportHTML"),e.$element.hasClass("export-xls")&&e.listenClick("exportEXCEL"),e.$element.hasClass("export-json")&&e.listenClick("exportJSON"),e.$element.hasClass("export-pdf")&&e.listenClick("exportPDF")},clean:function(t){var o,n=this,r=n.$table.clone(),i=n.$element.data("cssStyles")||{},a=n.$table.closest(".kv-grid-container"),s=n.skipExportElements,l=function(e){r.find(e+"."+n.gridId).remove()};s.length&&e.each(s,function(e,t){r.find(t).remove()}),"html"===t&&r.find(".kv-grid-boolean").remove(),o=a.hasClass("kv-grid-wrapper")?a.closest(".floatThead-wrapper").find(".kv-thead-float thead"):a.find(".kv-thead-float thead"),o.length&&(o=o.clone(),r.find("thead").before(o).remove()),r.find("tr.filters").remove(),r.find("th").removeAttr("rowspan"),r.find("th").find("a").each(function(){e(this).contents().unwrap()}),r.find("form,input,textarea,select,script").remove(),r.find("[onclick]").removeAttr("onclick"),r.find('a[href*="javascript"]').attr("href","#"),n.showHeader||r.children("thead").remove(),n.showPageSummary||l(".kv-page-summary-container"),n.showFooter||l(".kv-footer-container"),n.showCaption||l(".kv-caption-container"),r.find(".skip-export").remove(),r.find(".skip-export-"+t).remove(),r.find(".strip-tags-export").each(function(){var t=e(this),o=t.text();t.html(o)});var c=r.html();return c=n.preProcess(c,t),r.html(c),e.each(i,function(t,o){r.find(t).each(function(){var t=e(this),n=t.attr("style")||"";e.each(o,function(e,t){n+=e+":"+t+";"}),n&&t.attr("style",n)})}),r},preProcess:function(e,o){var n,r,i,a=this,s=a.exportConversions,l=s.length,c=e,p="from_"+o,d="to_"+o;if(l>0)for(var f=0;l>f;f++)n=s[f],r=void 0!==n[p]?n[p]:void 0!==n.from?n.from:"",i=void 0!==n[d]?n[d]:void 0!==n.to?n.to:"",r.length&&i.length&&(c=t.replaceAll(c,r,i));return c},download:function(o,n){var r,i,a=this,s=a.$element,l=s.attr("data-mime")||"text/plain",c=window.yii,p=s.attr("data-hash")||"",d=s.attr("data-hash-export-config"),f=t.isEmpty(a.config)?{}:a.config,h=a.target,m=function(t,o){return e("<textarea/>",{name:t}).val(o).hide()};"json"===o&&f.jsonReplacer&&delete f.jsonReplacer,r=c?m(c.getCsrfParam()||"_csrf",c.getCsrfToken()||null):null,i="_popup"===h,i&&(h="kvDownloadDialog",a.popup=t.popupDialog("",h,350,120),a.popup.focus(),a.setPopupAlert(a.messages.downloadProgress)),e("<form/>",{action:a.action,target:h,method:"post",css:{display:"none"}}).append(m("export_filetype",o),m("export_filename",a.filename)).append(m("export_encoding",a.encoding),m("export_bom",a.bom?1:0)).append(m("export_content",n),m("module_id",a.module),r).append(m("export_mime",l),m("export_hash",p),m("hash_export_config",d)).append(m("export_config",JSON.stringify(f))).appendTo("body").submit().remove(),i&&a.setPopupAlert(a.messages.downloadComplete,!0)},exportHTML:function(){var o,n=this,r=n.clean("html"),i=n.config,a=i.cssFile?i.cssFile:[],s="";o=t.templates.html.replace("{encoding}",n.encoding),e.each(a,function(e,t){s+='<link href="'+t+'" rel="stylesheet" crossorigin="anonymous">\n'}),o=o.replace("{css}",s).replace("{data}",e("<div />").html(r).html()),n.download("html",o)},exportPDF:function(){var o=this,n=o.clean("pdf"),r=t.isEmpty(o.config.contentBefore)?"":o.config.contentBefore,i=t.isEmpty(o.config.contentAfter)?"":o.config.contentAfter,a=o.config.css,s=t.templates.pdf.replace("{css}",a).replace("{before}",r).replace("{after}",i).replace("{data}",e("<div />").html(n).html());o.download("pdf",s)},exportTEXT:function(t){var o=this,n=o.clean(t),r=n.find("tr:has("+o.columns+")"),i=String.fromCharCode(11),a=String.fromCharCode(0),s='"'+o.config.colDelimiter+'"',l='"'+o.config.rowDelimiter+'"',c='"'+r.map(function(t,n){var r=e(n),a=r.find(o.columns);return a.map(function(t,o){var n=e(o),r=n.text().trim();return r.replace(/"/g,'""')}).get().join(i)}).get().join(a).split(a).join(l).split(i).join(s)+'"';o.download(t,c)},exportJSON:function(){var e=this,t=e.getArray("json");t=JSON.stringify(t,e.config.jsonReplacer,e.config.indentSpace),e.download("json",t)},exportEXCEL:function(){var o,n,r=this,i=r.clean("xls"),a=r.config,s=a.cssFile&&r.config.cssFile.length?'<link href="'+r.config.cssFile+'" rel="stylesheet">':"";i.find("td[data-raw-value]").each(function(){n=e(this),(n.css("mso-number-format")||0===n.css("mso-number-format")||"0"===n.css("mso-number-format"))&&n.html(n.attr("data-raw-value")).removeAttr("data-raw-value")}),o=t.templates.excel.replace("{encoding}",r.encoding).replace("{css}",s).replace("{worksheet}",r.config.worksheet).replace("{data}",e("<div />").html(i).html()).replace(/"/g,"'"),r.download("xls",o)}},e.fn.gridexport=function(t){var n=Array.apply(null,arguments);return n.shift(),this.each(function(){var r=e(this),i=r.data("gridexport"),a="object"==typeof t&&t;i||r.data("gridexport",i=new o(this,e.extend({},e.fn.gridexport.defaults,a,e(this).data()))),"string"==typeof t&&i[t].apply(i,n)})},e.fn.gridexport.defaults={dialogLib:"krajeeDialog"},e.fn.gridexport.Constructor=o}(window.jQuery);