/*!
 * strength-meter v1.1.4
 * http://plugins.krajee.com/strength-meter
 *
 * A dynamic strength meter for password input validation with various configurable options.
 *
 * The strength scoring calculation is inspired from [password meter](http://passwordmeter.com)
 * created by Jeff Todnem.
 *
 * Author: Kartik Visweswaran
 * Copyright: 2015 - 2017, Kartik Visweswaran, Krajee.com
 *
 * Licensed under the BSD 3-Clause
 * https://github.com/kartik-v/strength-meter/blob/master/LICENSE.md
 */!function(e){"use strict";var t,r;e.fn.strengthLocales={},String.prototype.strReverse=function(){for(var e="",t=0;t<this.length;t++)e=this.charAt(t)+e;return e},t={uniqId:function(){return Math.round((new Date).getTime()+100*Math.random())},isEmpty:function(t,r){return null===t||void 0===t||0===t.length||r&&""===e.trim(t)},replaceField:function(e,t){var r=e.$element,n=r.clone(!0).attr("type",t).insertAfter(r);r.remove(),e.$element=n},getVerdict:function(e){return 80>=e?0>=e?0:Math.ceil(e/20):5},getScore:function(e,r){if(t.isEmpty(e)||e.length<r.minLength)return 0;var n,a,s,l,i,o,c=0,u=0,g=0,d=0,p=0,v=0,h=0,f=0,m=0,b=0,C=0,$=0,k=0,y=0,w=0,S=0,T=0,L=r.midChar,M=r.consecAlphaUC,x=r.consecAlphaLC,V=r.consecNumber,I=r.seqAlpha,q=r.seqNumber,A=r.seqSymbol,D=r.length,E=r.number,N=r.symbol,O=-1,R=-1,j="",B="",F="abcdefghijklmnopqrstuvwxyz",U="01234567890",W=")!@#$%^&*()",z=e.length*D,G=e.length,H="",P=e.replace(/\s+/g,"").split(/\s*/),Q=P.length;for(l=0;Q>l;l++){if(H=P[l],H.toUpperCase()!==H){-1!==O&&O+1===l&&(m++,k++),O=l,c++;break}for(H.toLowerCase()!==H?(-1!==R&&R+1===l&&(b++,k++),R=l,u++):H.match(/[0-9]/g)?(l>0&&Q-1>l&&p++,""!==j&&j+1===l&&(C++,k++),j=l,g++):H.match(/[^\w]/g)&&(l>0&&Q-1>l&&p++,""!==B&&B+1===l&&($++,k++),B=l,d++),o=!1,i=0;Q>i;i++)P[l]===P[i]&&l!==i&&(o=!0,f+=Math.abs(Q/(i-l)));o&&(h++,v=Q-h,f=v?Math.ceil(f/v):Math.ceil(f))}for(n=0;23>n;n++)a=F.substring(n,n+3),s=a.strReverse(),-1===e.toLowerCase().indexOf(a)&&-1===e.toLowerCase().indexOf(s)||(y++,T++);for(n=0;8>n;n++)a=U.substring(n,n+3),s=a.strReverse(),-1===e.toLowerCase().indexOf(a)&&-1===e.toLowerCase().indexOf(s)||(w++,T++);for(n=0;8>n;n++)a=W.substring(n,n+3),s=a.strReverse(),-1===e.toLowerCase().indexOf(a)&&-1===e.toLowerCase().indexOf(s)||(S++,T++);return c>0&&G>c&&(z+=2*(G-c)),u>0&&G>u&&(z+=2*(G-u)),g>0&&G>g&&(z+=g*E),d>0&&(z+=d*N),p>0&&(z+=p*L),(u>0||c>0)&&0===d&&0===g&&(z-=G),0===u&&0===c&&0===d&&g>0&&(z-=G),h>0&&(z-=f),m>0&&(z-=m*M),b>0&&(z-=b*x),C>0&&(z-=C*V),y>0&&(z-=y*I),w>0&&(z-=w*q),S>0&&(z-=S*A),z=0>=z?G>=D?1:0:Math.min(z,100)}},r=function(r,n){var a,s=this;e.each(n,function(e,t){s[e]=t}),s.$element=e(r),s.verdicts=s.generateVerdicts(),s.setDefault("toggleClass","kv-toggle"),s.setDefault("meterClass","kv-meter"),s.setDefault("scoreBarClass","kv-scorebar"),s.setDefault("scoreClass","kv-score"),s.setDefault("verdictClass","kv-verdict"),s.setDefault("containerClass","kv-password"),t.isEmpty(s.$element.attr("id"))&&s.$element.attr("id",t.uniqId()),s.initialValue=t.isEmpty(s.$element.val())?"":s.$element.val(),a=t.getScore(s.initialValue,s.rules),s.$container=s.createContainer(),s.$elToggle=s.$container.find(".kv-toggle"),s.$elScorebar=s.$container.find(".kv-scorebar"),s.$elScore=s.$container.find(".kv-score"),s.$elVerdict=s.$container.find(".kv-verdict"),s.$elScoreInput=e(document.createElement("input")).attr("type","hidden").val(a),s.$container.append(s.$elScoreInput),s.paint(a),s.listen()},r.prototype={constructor:r,setDefault:function(e,r){var n=this;t.isEmpty(n[e])&&(n[e]=r)},generateVerdicts:function(){var e,t=this,r=[];for(e=0;6>e;e++)r[e]='<div class="'+t.verdictClasses[e]+'">'+t.verdictTitles[e]+"</div>";return r},listen:function(){var e=this;e.$element.on("keyup",function(t){e.change(t,this.value)}),e.$element.closest("form").on("reset",function(){e.reset()}),e.$elToggle.on("change",function(){e.toggle()})},paint:function(e){var r=this,n=t.getVerdict(e),a=r.verdicts[n];r.$elScore.attr("class",r.scoreClass+" "+r.scoreClass+"-"+n),r.$elScorebar.css("background-position",0-4*e+"px"),r.$elScore.html(e+"%"),r.$elVerdict.html(a)},change:function(e,r){var n=this,a=t.getScore(r,n.rules);n.$elScoreInput.val(a),n.paint(a),n.$element.trigger("strength:change")},refresh:function(){var e=this,r=t.getScore(e.$element.val(),e.rules);e.$elScoreInput.val(r),e.paint(r)},reset:function(){var e=this,r=t.getScore(e.initialValue,e.rules);e.$elScoreInput.val(r),e.paint(r),t.replaceField(e,"password"),e.$element.trigger("strength:reset")},toggle:function(){var e=this,r=e.$elToggle.is(":checked")?"text":"password";t.replaceField(e,r),e.$element.trigger("strength:toggle")},score:function(){return this.$elScoreInput.val()},verdict:function(){var e=this.$elScoreInput.val();return t.getVerdict(e)},createContainer:function(){var t,r,n=this,a=n.mainTemplate;return a=a.replace("{input}",n.renderInput()).replace("{meter}",n.renderMeter()),t=e(document.createElement("div")).addClass(n.containerClass).html(a),n.$element.before(t),r=n.$element.detach(),t.find(".kv-temporary-input").before(r).remove(),t},renderToggle:function(){var e=this,t=e.$element.attr("disabled")?' disabled="true"':"",r=e.$element.attr("readonly")?' readonly="true"':"";return'<input type="checkbox" tabindex=10000 class="'+e.toggleClass+'" title="'+e.toggleTitle+'"'+t+r+">"},renderInput:function(){var e=this,t=e.toggleMask?e.inputTemplate:e.inputNoToggleTemplate;return e.$element.removeClass(e.inputClass).addClass(e.inputClass),t=t.replace("{input}",'<div class="kv-temporary-input"></div>'),e.toggleMask&&(t=t.replace("{toggle}",e.renderToggle())),t},renderMeter:function(){var e,t=this,r=t.meterTemplate;return t.showMeter?(r=r.replace("{scorebar}",'<div class="'+t.scoreBarClass+'"></div>').replace("{score}",'<div class="'+t.scoreClass+'"></div>').replace("{verdict}",'<div class="'+t.verdictClass+'"></div>'),e=t.$element.attr("disabled")?t.meterClass+" kv-disabled":t.meterClass,'<div class="'+e+'">'+r+"</div>"):""}},e.fn.strength=function(n){var a=Array.apply(null,arguments),s=[];switch(a.shift(),this.each(function(){var l,i=e(this),o=i.data("strength"),c="object"==typeof n&&n,u={},g=c.language||i.data("language")||e.fn.strength.defaults.language||"en";o||("en"===g||t.isEmpty(e.fn.strengthLocales[g])||(u=e.fn.strengthLocales[g]||{}),l=e.extend(!0,{},e.fn.strength.defaults,e.fn.strengthLocales.en,u,c,i.data()),o=new r(this,l),i.data("strength",o)),"string"==typeof n&&s.push(o[n].apply(o,a))}),s.length){case 0:return this;case 1:return s[0];default:return s}},e.fn.strength.defaults={language:"en",showMeter:!0,toggleMask:!0,inputTemplate:'<div class="input-group">\n{input}\n<span class="input-group-addon input-group-append"><span class="input-group-text">{toggle}</span></span>\n</div>',inputNoToggleTemplate:"{input}",meterTemplate:'<div class="kv-scorebar-border">{scorebar}\n{score}</div>\n{verdict}',mainTemplate:'<table class="kv-strength-container"><tr>\n<td>{input}</td>\n<td class="kv-meter-container">{meter}</td>\n</tr></table>',meterClass:"kv-meter",scoreBarClass:"kv-scorebar",scoreClass:"kv-score",verdictClass:"kv-verdict",containerClass:"kv-password",inputClass:"form-control",toggleClass:"kv-toggle",verdictClasses:{0:"label label-default badge-secondary",1:"label label-danger badge-danger",2:"label label-warning badge-warning",3:"label label-info badge-info",4:"label label-primary badge-primary",5:"label label-success badge-success"},rules:{minLength:2,midChar:2,consecAlphaUC:2,consecAlphaLC:2,consecNumber:2,seqAlpha:3,seqNumber:3,seqSymbol:3,length:4,number:4,symbol:6}},e.fn.strengthLocales.en={toggleTitle:"Show/Hide Password",verdictTitles:{0:"Too Short",1:"Very Weak",2:"Weak",3:"Good",4:"Strong",5:"Very Strong"}},e.fn.strength.Constructor=r,e(function(){var t=e("input.strength[type=password]");t.length>0&&t.strength()})}(window.jQuery);