<?php
/**
 * @link http://www.yiiframework.com/
 * @copyright Copyright (c) 2008 Yii Software LLC
 * @license http://www.yiiframework.com/license/
 */

namespace backend\widgets;

use Yii;
use yii\base\InvalidConfigException;
use yii\base\Widget;
use yii\helpers\ArrayHelper;
use yii\helpers\Html;


class Actions extends Widget
{
    
    public $encodeLabels = true;
    
    public $links = [];

    public function run()
    {
        if (empty($this->links)) {
            return;
        }
        $links = [];

        foreach ($this->links as $link) {
            if (!is_array($link)) {
                $link = ['label' => $link];
            }
            $links[] = $this->renderItem($link);
        }
        echo implode('', $links);
    }

    public function renderItem($link)
    {

        $encodeLabel = ArrayHelper::remove($link, 'encode', $this->encodeLabels);
        
        if (array_key_exists('label', $link)) {
            $label = $encodeLabel ? Html::encode($link['label']) : $link['label'];
        } else {
            throw new InvalidConfigException('El elemento "label" es requerido para cada botón de acción.');
        }
        
        if (isset($link['icon'])) {
            $icon = $link['icon'];
        } else {
            $icon = '<i class="fas fa-trash"></i>';
        }
        
        if (isset($link['class'])) {
            $class = $link['class'];
        } else {
            $class = 'default';
        }

        if (isset($link['action'])) {
            $action = $link['action'];
        } else {
            $action = '';
        }

        if (isset($link['url'])) {
            
            $url = $link['url'];

            if($url == 'imprimir')
            {
                $link = Html::a($icon.' '.$label, 'javascript:window.print();', ['class' => 'btn btn-md btn-'.$class]);    
            }
            else if($url == 'delete')
            {
                $link = Html::a($icon.' '.$label, [$url,'id' => $link['id']], ['class' => 'btn btn-md btn-'.$class, 'data' => [
                    'confirm' => 'Desea eliminar este elemento?',
                    'method' => 'post',]]);    
            }
            else
            {
                if (isset($link['id'])) 
                {
                    $link = Html::a($icon.' '.$label, [$url,'id' => $link['id']], ['class' => 'btn btn-md btn-'.$class, 'id' => $action]);   
                }
                else
                {
                    $link = Html::a($icon.' '.$label, $url, ['class' => 'btn btn-md btn-'.$class, 'id' => $action]);
                }
                
            }    
        } 
        else 
        {
            $link = $label;
        }

        return $link;
    }
}
