CREATE TABLE `bitacora` (
  `id` int(5) NOT NULL COMMENT 'Id',
  `accion` varchar(255) DEFAULT NULL COMMENT 'Acción',
  `controlador` varchar(255) DEFAULT NULL COMMENT 'Controlador',
  `tercero` int(3) NULL COMMENT 'Tercero',
  `periodo` int(1) NOT NULL COMMENT 'Periodo',
  `descripcion` longtext CHARACTER SET latin1 COLLATE latin1_spanish_ci COMMENT 'Descripción',
  `ejecutor` int(3) NULL COMMENT 'Ejecutor',
  `creado_el` datetime DEFAULT NULL COMMENT 'Creado El',
  `creado_por` int(5) DEFAULT NULL COMMENT 'Creado Por',
  `actualizado_el` datetime DEFAULT NULL COMMENT 'Actualizado El',
  `actualizado_por` int(5) DEFAULT NULL COMMENT 'Actualizado Por',
  `eliminado_el` datetime DEFAULT NULL COMMENT 'Eliminado El',
  `eliminado_por` int(3) DEFAULT '0' COMMENT 'Eliminado Por',
  `estado` int(1) NOT NULL DEFAULT '1' COMMENT 'Estado'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

ALTER TABLE `bitacora`
  ADD PRIMARY KEY (`id`),
  ADD KEY `tercero` (`tercero`),
  ADD KEY `periodo` (`periodo`),
  ADD KEY `ejecutor` (`ejecutor`);

ALTER TABLE `bitacora`
  MODIFY `id` int(5) NOT NULL AUTO_INCREMENT COMMENT 'Id', AUTO_INCREMENT=1;

ALTER TABLE `bitacora`
  ADD CONSTRAINT `bitacora_ibfk_1` FOREIGN KEY (`tercero`) REFERENCES `tercero` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `bitacora_ibfk_2` FOREIGN KEY (`ejecutor`) REFERENCES `tercero` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `bitacora_ibfk_3` FOREIGN KEY (`periodo`) REFERENCES `periodo` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;
