DROP TABLE IF EXISTS `campana_tipo`;

CREATE TABLE `campana_tipo` (
  `id` int(3) NOT NULL COMMENT 'Id',
  `tipo` varchar(255) CHARACTER SET latin1 COLLATE latin1_spanish_ci DEFAULT NULL COMMENT 'Tipo',
  `tipo_tercero` int(3) NOT NULL COMMENT 'Tipo de Tercero',
  `creado_el` datetime DEFAULT NULL COMMENT 'Creado El',
  `creado_por` int(5) DEFAULT NULL COMMENT 'Creado Por',
  `actualizado_el` datetime DEFAULT NULL COMMENT 'Actualizado El',
  `actualizado_por` int(5) DEFAULT NULL COMMENT 'Actualizado Por',
  `eliminado_por` int(5) DEFAULT '0' COMMENT 'Eliminado Por',
  `eliminado_el` datetime DEFAULT NULL COMMENT 'Eliminado El',
  `estado` int(1) NOT NULL DEFAULT '1' COMMENT 'Estado'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


INSERT INTO `campana_tipo` (`id`, `tipo`, `color`,`tipo_tercero`, `creado_el`, `creado_por`, `actualizado_el`, `actualizado_por`, `eliminado_por`, `eliminado_el`, `estado`) VALUES
(1, 'Tesorero', '#dd4659', 1,NOW(), 1, NOW(), 1, 0, NULL, 1),
(2, 'Personero', '#febb3b',1,NOW(), 1, NOW(), 1, 0, NULL, 1),
(3, 'Contralor', '#5499c7',1,NOW(), 1, NOW(), 1, 0, NULL, 1),
(4, 'Representante de Grado', '#fad53e',1,NOW(), 1, NOW(), 1, 0, NULL, 1),
(5, 'Representante de Grupo', '#ffa726',2,NOW(), 1, NOW(), 1, 0, NULL, 1),
(6, 'Consejo Directivo', '#8b75d7',2,NOW(), 1, NOW(), 1, 0, NULL, 1);


ALTER TABLE `campana_tipo`
  ADD PRIMARY KEY (`id`),
  ADD KEY `tipo_tercero` (`tipo_tercero`);

ALTER TABLE `campana_tipo`
  MODIFY `id` int(3) NOT NULL AUTO_INCREMENT COMMENT 'Id', AUTO_INCREMENT=6;


ALTER TABLE `campana_tipo`
  ADD CONSTRAINT `campana_tipo_ibfk_1` FOREIGN KEY (`tipo_tercero`) REFERENCES `tipo_tercero` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;
  


DROP TABLE IF EXISTS `campana`;

CREATE TABLE `campana` (
  `id` int(3) NOT NULL COMMENT 'Id',
  `campana` varchar(255) NOT NULL COMMENT 'Campaña',
  `tipo` int(3) DEFAULT NULL COMMENT 'Tipo de Campaña',
  `grado` int(3) DEFAULT NULL COMMENT 'Grado',
  `grupo` int(3) DEFAULT NULL COMMENT 'Grupo',
  `fecha_inicio` datetime NOT NULL COMMENT 'Fecha de Inicio',
  `fecha_fin` datetime NOT NULL COMMENT 'Fecha de Finalización',
  `creado_el` datetime DEFAULT NULL COMMENT 'Creado El',
  `creado_por` int(5) DEFAULT NULL COMMENT 'Creado Por',
  `actualizado_el` datetime DEFAULT NULL COMMENT 'Actualizado El',
  `actualizado_por` int(5) DEFAULT NULL COMMENT 'Actualizado Por',
  `eliminado_el` datetime DEFAULT NULL COMMENT 'Eliminado El',
  `eliminado_por` int(5) DEFAULT '0' COMMENT 'Eliminado Por',
  `estado` int(1) NOT NULL COMMENT 'Estado'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

ALTER TABLE `campana`
  ADD PRIMARY KEY (`id`),
  ADD KEY `tipo` (`tipo`),
  ADD KEY `grado` (`grado`),
  ADD KEY `grupo` (`grupo`);

ALTER TABLE `campana`
  MODIFY `id` int(3) NOT NULL AUTO_INCREMENT COMMENT 'Id';


ALTER TABLE `campana`
  ADD CONSTRAINT `campana_ibfk_1` FOREIGN KEY (`tipo`) REFERENCES `campana_tipo` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `campana_ibfk_2` FOREIGN KEY (`grado`) REFERENCES `grado` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `campana_ibfk_3` FOREIGN KEY (`grupo`) REFERENCES `grupo` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;



DROP TABLE IF EXISTS `campana_item`;

CREATE TABLE `campana_item` (
  `id` int(3) NOT NULL COMMENT 'Id',
  `campana` int(3) NOT NULL COMMENT 'Campaña', 
  `tercero` int(5) NOT NULL COMMENT 'Tercero',
  `mensaje` longtext COMMENT 'Mensaje',
  `adjunto` longtext COMMENT 'Adjunto',
  `foto` varchar(255) DEFAULT NULL COMMENT 'Foto',
  `creado_el` datetime DEFAULT NULL COMMENT 'Creado El',
  `creado_por` int(5) DEFAULT NULL COMMENT 'Creado Por',
  `actualizado_el` datetime DEFAULT NULL COMMENT 'Actualizado El',
  `actualizado_por` int(5) DEFAULT NULL COMMENT 'Actualizado Por',
  `eliminado_el` datetime DEFAULT NULL COMMENT 'Eliminado El',
  `eliminado_por` int(5) DEFAULT '0' COMMENT 'Eliminado Por',
  `estado` int(1) NOT NULL COMMENT 'Estado'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

ALTER TABLE `campana_item`
  ADD PRIMARY KEY (`id`),
  ADD KEY `campana` (`campana`),
  ADD KEY `tercero` (`tercero`);

ALTER TABLE `campana_item`
  MODIFY `id` int(3) NOT NULL AUTO_INCREMENT COMMENT 'Id';


ALTER TABLE `campana_item`
  ADD CONSTRAINT `campana_item_ibfk_1` FOREIGN KEY (`campana`) REFERENCES `campana` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `campana_item_ibfk_2` FOREIGN KEY (`tercero`) REFERENCES `tercero` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;




DROP TABLE IF EXISTS `campana_voto`;

CREATE TABLE `campana_voto` (
  `id` int(3) NOT NULL COMMENT 'Id',
  `campana` int(3) DEFAULT NULL COMMENT 'Campaña', 
  `item` int(3) NOT NULL COMMENT 'Item',
  `creado_el` datetime DEFAULT NULL COMMENT 'Creado El',
  `creado_por` int(5) DEFAULT NULL COMMENT 'Creado Por',
  `actualizado_el` datetime DEFAULT NULL COMMENT 'Actualizado El',
  `actualizado_por` int(5) DEFAULT NULL COMMENT 'Actualizado Por',
  `eliminado_el` datetime DEFAULT NULL COMMENT 'Eliminado El',
  `eliminado_por` int(5) DEFAULT '0' COMMENT 'Eliminado Por',
  `estado` int(1) NOT NULL COMMENT 'Estado'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

ALTER TABLE `campana_voto`
  ADD PRIMARY KEY (`id`),
  ADD KEY `campana` (`campana`),
  ADD KEY `item` (`item`);

ALTER TABLE `campana_voto`
  MODIFY `id` int(3) NOT NULL AUTO_INCREMENT COMMENT 'Id';


ALTER TABLE `campana_voto`
  ADD CONSTRAINT `campana_voto_ibfk_1` FOREIGN KEY (`campana`) REFERENCES `campana` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `campana_voto_ibfk_2` FOREIGN KEY (`item`) REFERENCES `campana_item` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;
