<?php
namespace common\models;

use Yii;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\web\HttpException;
use yii\filters\VerbFilter;

use yii\base\Model;
use backend\models\Tercero;


/**
 * Login form
 */
class LoginForm extends Model
{
    public $username;
    public $password;
    public $rememberMe = true;

    private $_user;


    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            // username and password are both required
            [['username', 'password'], 'required'],
            // rememberMe must be a boolean value
            ['rememberMe', 'boolean'],
            // password is validated by validatePassword()
            ['password', 'validatePassword'],
        ];
    }

    public function attributeLabels()
    {
        return [
            'username' => 'Usuario', 
            'password' => 'Contraseña',
            'rememberMe' => 'Recordarme',
        ];
    }
    /**
     * Validates the password.
     * This method serves as the inline validation for password.
     *
     * @param string $attribute the attribute currently being validated
     * @param array $params the additional name-value pairs given in the rule
     */
    public function validatePassword($attribute, $params)
    {
        if (!$this->hasErrors()) {
            $user = $this->getUser();
            if (!$user || !$user->validatePassword($this->password)) {
                $this->addError($attribute, 'Incorrect username or password.');
            }
        }
    }

    /**
     * Logs in a user using the provided username and password.
     *
     * @return boolean whether the user is logged in successfully
     */
    public function login()
    {
        if ($this->validate()) {

            Yii::$app->session->set('__doc', strtolower($this->username));

            if(strtolower($this->username) != 'admin')
            {    
                $tercero = Tercero::find()
                            ->where(['identificacion' => strtolower($this->username)])
                            ->one();

                
                /*if(($tercero->estado == '9') && ($tercero->tipo_tercero == '1'))
                {
                    return $this->redirect(['tercero/step1', 'id' => Yii::$app->session->get('__tercero')]);
                }
                */

                if(($tercero->estado == '4') OR ($tercero->estado == '5') && ($tercero->tipo_tercero == '1'))
                {
                    throw new NotFoundHttpException('Lo sentimos, el usuario proporcionado no tiene permiso para ingresar al sistema porque su estado es <b>'.$tercero->estados->estado.'</b>, debes acercarte a la institución educativa para solucionarlo.');
                    return false;
                }
                

                //if(($tercero->activo == '0') && ($tercero->tipo_tercero == '1'))
                if($tercero->activo == '0') 
                {
                    throw new NotFoundHttpException('Lo sentimos, el usuario proporcionado no tiene permiso para ingresar al sistema porque su estado es <b>Inactivo</b>, debes acercarte a la institución educativa para solucionarlo.');
                    return false;
                }

                
                Yii::$app->session->set('__tercero', $tercero->id);
                Yii::$app->session->set('__tipo', $tercero->tipo_tercero);
                Yii::$app->session->set('__genero', $tercero->genero);
            }
            else
            {
                Yii::$app->session->set('__tercero', '');
                Yii::$app->session->set('__tipo', '4');
                Yii::$app->session->set('__genero', 'M');
            }    

            return Yii::$app->user->login($this->getUser(), $this->rememberMe ? 3600 * 24 * 30 : 0);

        } else {
            return false;
        }
    }

    /**
     * Finds user by [[username]]
     *
     * @return User|null
     */
    protected function getUser()
    {
        if ($this->_user === null) {
            $this->_user = User::findByUsername($this->username);
        }

        return $this->_user;
    }
}
