<?php

namespace common\rbac;

use Yii;

use yii\rbac\Rule;

class AuthorRule extends Rule
{
    public $name = 'isAuthor';

    public function execute($user, $item, $params)
    {
        if(Yii::$app->controller->action->id === 'update' || Yii::$app->controller->action->id === 'delete')
        {
            if(isset($params['model']))
            {
                $model = $params['model'];
            }
            else
            {
                $id = Yii::$app->request->get('id');
                $model = Yii::$app->controller->findUserModel($id);
            }

            if(Yii::$app->session->get('__tipo') == 3 || Yii::$app->session->get('__doc') == 'admin')
            {
                return true;
            }
            else
            {
                return $model->creado_por == $user;
            }
        }
        else
        {
            return true;
        }

    }
}
?>