<?php

namespace common\widgets;

use kartik\widgets\Growl;
use yii\helpers\Html;

/**
 * Alert widget renders a message from session flash. All flash messages are displayed
 * in the sequence they were assigned using setFlash. You can set message as following:
 *
 * ```php
 * \Yii::$app->session->setFlash('error', 'This is the message');
 * \Yii::$app->session->setFlash('success', 'This is the message');
 * \Yii::$app->session->setFlash('info', 'This is the message');
 * ```
 *
 * Multiple messages could be set as follows:
 *
 * ```php
 * \Yii::$app->session->setFlash('error', ['Error 1', 'Error 2']);
 * ```
 *
 * @author Kartik Visweswaran <kartikv2@gmail.com>
 * @author Alexander Makarov <sam@rmcreative.ru>
 */
class Alert extends \yii\bootstrap\Widget
{
    /**
     * @var array the alert types configuration for the flash messages.
     * This array is setup as $key => $value, where:
     * - $key is the name of the session flash variable
     * - $value is the bootstrap alert type (i.e. danger, success, info, warning)
     */
    public $alertTypes = [
        'error'   => 'alert-danger',
        'danger'  => 'alert-danger',
        'success' => 'alert-success',
        'info'    => 'alert-info',
        'warning' => 'alert-warning'
    ];

    /**
     * @var array the options for rendering the close button tag.
     */
    public $closeButton = [];

    public function init()
    {
        parent::init();
/*
        $session = \Yii::$app->session;
        $flashes = $session->getAllFlashes();
        $appendCss = isset($this->options['class']) ? ' ' . $this->options['class'] : '';

        foreach ($flashes as $type => $data) {
            if (isset($this->alertTypes[$type])) {
                $data = (array) $data;
                foreach ($data as $i => $message) {
                    
                    $this->options['class'] = $this->alertTypes[$type] . $appendCss;

                    
                    $this->options['id'] = $this->getId() . '-' . $type . '-' . $i;

                    echo \yii\bootstrap\Alert::widget([
                        'body' => $message,
                        'closeButton' => $this->closeButton,
                        'options' => $this->options,
                    ]);
                }

                //$session->removeFlash($type);
            }
        }*/
            
            if(!empty(\Yii::$app->session->getAllFlashes())){

                    foreach (\Yii::$app->session->getAllFlashes() as $box)
                    { 

                      foreach ($box as $message)
                      {    

                        echo Growl::widget([
                            'type' => (!empty($message['tipo'])) ? $message['tipo'] : 'info',
                            'title'=> (!empty($message['titulo'])) ? $message['titulo'] : 'Sonic!',
                            'icon' => (!empty($message['icono'])) ? $message['icono'] : 'fa fa-info',
                            'body' => (!empty($message['mensaje'])) ? $message['mensaje'] : 'Mensaje no configurado!',
                            'showSeparator' => true,
                            'delay' => (!empty($message['retardo'])) ? $message['retardo'] : 100,
                            'pluginOptions' => [
                                'delay' => $message['tipo'] == 'danger' ? 15000 : 5000, 
                                'showProgressbar' => (!empty($message['progreso'])) ? $message['progreso'] : true,                
                                'placement' => [
                                    'from' => (!empty($message['posicion'])) ? $message['posicion'] : 'top',
                                    'align' => (!empty($message['lado'])) ? $message['lado'] : 'right',
                                ]
                            ]
                        ]);
                    }
                } 
             }

    }
}
