
CREATE TABLE `tipo_condicion` (
  `id` int(3) NOT NULL COMMENT 'Id',
  `tipo` varchar(255) CHARACTER SET latin1 COLLATE latin1_spanish_ci DEFAULT NULL COMMENT 'Tipo',
  `creado_el` datetime DEFAULT NULL COMMENT 'Creado El',
  `creado_por` int(5) DEFAULT NULL COMMENT 'Creado Por',
  `actualizado_el` datetime DEFAULT NULL COMMENT 'Actualizado El',
  `actualizado_por` int(5) DEFAULT NULL COMMENT 'Actualizado Por',
  `eliminado_por` int(5) DEFAULT '0' COMMENT 'Eliminado Por',
  `eliminado_el` datetime DEFAULT NULL COMMENT 'Eliminado El',
  `estado` int(1) NOT NULL DEFAULT '1' COMMENT 'Estado'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `tipo_condicion` (`id`, `tipo`, `creado_el`, `creado_por`, `actualizado_el`, `actualizado_por`, `eliminado_por`, `eliminado_el`, `estado`) VALUES
(1, 'Área', NOW(), 1, NOW(), 1, 0, NULL, 1),
(2, 'Asignatura', NOW(), 1, NOW(), 1, 0, NULL, 1),
(3, 'Máximo de Áreas', NOW(), 1, NOW(), 1, 0, NULL, 1),
(4, 'Máximo de Asignaturas', NOW(), 1, NOW(), 1, 0, NULL, 1),
(5, 'Máximo de Ausentismo', NOW(), 1, NOW(), 1, 0, NULL, 1),
(6, 'Máximo de Ausentismo por Asignatura', NOW(), 1, NOW(), 1, 0, NULL, 1);

ALTER TABLE `tipo_condicion`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `tipo_condicion`
  MODIFY `id` int(3) NOT NULL AUTO_INCREMENT COMMENT 'Id', AUTO_INCREMENT=7;



--
-- CONDICION DE PROMOCION
--


CREATE TABLE `condicion_promocion` (
  `id` int(3) NOT NULL COMMENT 'Id',
  `tipo` int(3) NOT NULL COMMENT 'Tipo de Condición',
  `grado` int(3) NULL COMMENT 'Grado',
  `area` int(3) NULL COMMENT 'Área',
  `asignatura` int(3) NULL COMMENT 'Asignatura',
  `desempeno` int(3) NULL COMMENT 'Desempeño',
  `numero_areas` int(3) NULL COMMENT 'Número de Áreas',
  `numero_asignaturas` int(3) NULL COMMENT 'Número de Asignaturas',
  `numero_ausentismo` int(3) NULL COMMENT 'Número de Ausentismo',
  `descripcion` longtext NULL COMMENT 'Descripción',

  `creado_el` datetime DEFAULT NULL COMMENT 'Creado El',
  `creado_por` int(5) DEFAULT NULL COMMENT 'Creado Por',
  `actualizado_el` datetime DEFAULT NULL COMMENT 'Actualizado El',
  `actualizado_por` int(5) DEFAULT NULL COMMENT 'Actualizado Por',
  `eliminado_el` datetime DEFAULT NULL COMMENT 'Eliminado El',
  `eliminado_por` int(5) DEFAULT '0' COMMENT 'Eliminado Por',
  `estado` int(1) NOT NULL DEFAULT '1' COMMENT 'Estado'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

ALTER TABLE `condicion_promocion`
  ADD PRIMARY KEY (`id`),
  ADD KEY `tipo` (`tipo`),
  ADD KEY `grado` (`grado`),
  ADD KEY `area` (`area`),
  ADD KEY `asignatura` (`asignatura`),
  ADD KEY `desempeno` (`desempeno`);

ALTER TABLE `condicion_promocion`
  MODIFY `id` int(3) NOT NULL AUTO_INCREMENT COMMENT 'Id', AUTO_INCREMENT=1;

ALTER TABLE `condicion_promocion`
  ADD CONSTRAINT `condicion_promocion_ibfk_1` FOREIGN KEY (`tipo`) REFERENCES `tipo_condicion` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `condicion_promocion_ibfk_2` FOREIGN KEY (`grado`) REFERENCES `grado` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `condicion_promocion_ibfk_3` FOREIGN KEY (`area`) REFERENCES `area` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `condicion_promocion_ibfk_4` FOREIGN KEY (`asignatura`) REFERENCES `asignatura` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `condicion_promocion_ibfk_5` FOREIGN KEY (`desempeno`) REFERENCES `desempeno` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;
  

ALTER TABLE `asignatura` ADD `principal` INT(1) NULL DEFAULT '1' COMMENT 'Asignatura Principal' AFTER `por_asig_area`; 
UPDATE `asignatura` SET principal="1" WHERE `asignatura` LIKE '%ingles%';
UPDATE `asignatura` SET principal="0" WHERE `asignatura` LIKE '%art%';
UPDATE `asignatura` SET principal="0" WHERE `asignatura` LIKE '%inform%';
UPDATE `asignatura` SET principal="0" WHERE `asignatura` LIKE '%dep%';
UPDATE `asignatura` SET principal="0" WHERE `asignatura` LIKE '%etica%';
UPDATE `asignatura` SET principal="0" WHERE `asignatura` LIKE '%reli%';



ALTER TABLE `asignatura` ADD `excluida_promocion` INT(1) NULL DEFAULT '0' COMMENT 'Excluida Para Promoción' AFTER `principal`; 
UPDATE `asignatura` SET excluida_promocion="1" WHERE `asignatura` LIKE '%tecnica%'
UPDATE `asignatura` SET excluida_promocion="1" WHERE `asignatura` LIKE '%artis%'
UPDATE `asignatura` SET excluida_promocion="1" WHERE `asignatura` LIKE '%democ%'



ALTER TABLE `carga` ADD `director_area` INT(1) NULL DEFAULT '1' COMMENT 'Director del Área' AFTER `grupo`; 
