<?php

use yii\db\Schema;
use yii\db\Migration;

class m130524_201442_init extends Migration
{
    public function up()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            // http://stackoverflow.com/questions/766809/whats-the-difference-between-utf8-general-ci-and-utf8-unicode-ci
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%user}}', [
            'id' => $this->primaryKey(),
            'username' => $this->string()->notNull()->unique(),
            'name' => $this->string()->notNull(),
            'auth_key' => $this->string(32)->notNull(),
            'password_hash' => $this->string()->notNull(),
            'password_reset_token' => $this->string()->unique(),
            'email' => $this->string()->notNull()->unique(),
            'instituto' => $this->integer(2),
            'status' => $this->smallInteger()->notNull()->defaultValue(10),
            'created_at' => $this->integer()->notNull(),
            'updated_at' => $this->integer()->notNull(),
        ], $tableOptions);

        $this->createIndex('id-instituto', 'user', 'instituto');
        
        $this->insert('{{%user}}', array(
            'id' => NULL,
            'username' => 'admin',
            'name' => 'Iván Acosta',
            'auth_key' => 'hl1wnQNuiSZyrO1YkpWa2VAV8KvLavq-',
            'password_hash' => '$2y$13$w5sMwa7qIsai74Ka54Mx1.p.OEkghIpusZi4r./mKAX.8tdAMaVEm',
            'password_reset_token' => NULL,
            'email' => 'acosta@gsol.co',
            'instituto' => '1',
            'status' => '10',
            'created_at' => '1453317782',
            'updated_at' => '1453317782',
         ));
         
    }

    public function down()
    {
        $this->dropTable('{{%user}}');
    }
}
