<?php

use yii\db\Schema;
use yii\db\Migration;

class m160318_113158_crear_instituciones extends Migration
{
    public function up()
    {

        $this->createTable('{{%instituciones}}', [
            'id' => $this->primaryKey(),
            'nit' => $this->string(15),
            'instituto' => $this->string(30)->notNull(),
            'direccion' => $this->string(30)->notNull(),
            'fijo' => $this->string(30)->notNull(),
            'resolucion' => $this->string(30)->notNull(),
            'dane' => $this->string(30)->notNull(),
            'rector_nombre' => $this->string(30)->notNull(),
            'rector_cc' => $this->string(30)->notNull(),
            'rector_expedida' => $this->string(30)->notNull(),
            'rector_movil' => $this->string(10)->notNull(),   
            'rector_email' => $this->string()->notNull()->unique(),
        ]);
        //$this->alterColumn('{{%instituciones}}', 'id', $this->integer(2).' NOT NULL AUTO_INCREMENT');
        $this->insert('{{%instituciones}}', array(
            'id' => NULL,
            'nit' => '8220012621',
            'instituto' => 'Institución Educativa Gabriela Mistral',
            'direccion' => 'Calle 13 N° 14-55 Centro, Acacias',
            'fijo' => '6569638',
            'resolucion' => '3513 del 13 de Octubre del 2009 y modificada según Resolución 5753 del 12 Noviembre de 2013',
            'dane' => '150006000322',
            'rector_nombre' => 'Emma Floralba Gutierrez Caro',
            'rector_cc' => '40401475',
            'rector_expedida' => 'Villavicencio',
            'rector_movil' => '3013374037',
            'rector_email' => 'acosta@gsol.co',
         ));
        //                      nombre               tabla fk  campo fk     tabla pk       campo pk  delete   update
        $this->addForeignKey ('fk-instituciones-user', 'user', 'instituto', 'instituciones', 'id', 'CASCADE', 'CASCADE');
        
    }

    public function down()
    {
        $this->dropTable('{{%instituciones}}');
    }

    /*
    // Use safeUp/safeDown to run migration code within a transaction
    public function safeUp()
    {
    }

    public function safeDown()
    {
    }
    */
}
