CREATE TABLE `frd_tipo` (
  `id` int(3) NOT NULL COMMENT 'Id',
  `tipo` varchar(255) CHARACTER SET latin1 COLLATE latin1_spanish_ci COMMENT 'Tipo',
  `creado_el` datetime DEFAULT NULL COMMENT 'Creado El',
  `creado_por` int(5) DEFAULT NULL COMMENT 'Creado Por',
  `actualizado_el` datetime DEFAULT NULL COMMENT 'Actualizado El',
  `actualizado_por` int(5) DEFAULT NULL COMMENT 'Actualizado Por',
  `eliminado_por` int(5) DEFAULT '0' COMMENT 'Eliminado Por',
  `eliminado_el` datetime DEFAULT NULL COMMENT 'Eliminado El',
  `estado` int(1) NOT NULL DEFAULT '1' COMMENT 'Estado'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


ALTER TABLE `frd_tipo`
  ADD PRIMARY KEY (`id`);


ALTER TABLE `frd_tipo`
  MODIFY `id` int(3) NOT NULL AUTO_INCREMENT COMMENT 'Id', AUTO_INCREMENT=1;

CREATE TABLE `frd` (
  `id` int(3) NOT NULL COMMENT 'Id',
  `competencia` int(3) NOT NULL COMMENT 'Competencia',
  `desempeno` int(3) NOT NULL COMMENT 'Nivel de Desempeño',
  `frd_tipo` int(3) NOT NULL COMMENT 'Tipo',
  `descripcion` longtext CHARACTER SET latin1 COLLATE latin1_spanish_ci COMMENT 'Descripción',
  `creado_el` datetime DEFAULT NULL COMMENT 'Creado El',
  `creado_por` int(5) DEFAULT NULL COMMENT 'Creado Por',
  `actualizado_el` datetime DEFAULT NULL COMMENT 'Actualizado El',
  `actualizado_por` int(5) DEFAULT NULL COMMENT 'Actualizado Por',
  `eliminado_por` int(5) DEFAULT '0' COMMENT 'Eliminado Por',
  `eliminado_el` datetime DEFAULT NULL COMMENT 'Eliminado El',
  `estado` int(1) NOT NULL DEFAULT '1' COMMENT 'Estado'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


ALTER TABLE `frd`
  ADD PRIMARY KEY (`id`),
  ADD KEY `competencia` (`competencia`),
  ADD KEY `desempeno` (`desempeno`),
  ADD KEY `frd_tipo` (`frd_tipo`);


ALTER TABLE `frd`
  MODIFY `id` int(3) NOT NULL AUTO_INCREMENT COMMENT 'Id', AUTO_INCREMENT=1;

ALTER TABLE `frd`
  ADD CONSTRAINT `frd_ibfk_1` FOREIGN KEY (`competencia`) REFERENCES `competencia` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `frd_ibfk_2` FOREIGN KEY (`desempeno`) REFERENCES `desempeno` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `frd_ibfk_3` FOREIGN KEY (`frd_tipo`) REFERENCES `frd_tipo` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;








CREATE TABLE `nivel` (
  `id` int(3) NOT NULL COMMENT 'Id',
  `grado` int(3) NOT NULL COMMENT 'Grado',
  `asignatura` int(3) NOT NULL COMMENT 'Asignatura',
  `periodo` int(1) NOT NULL COMMENT 'Periodo',
  `competencia` int(3) NOT NULL COMMENT 'Competencia',
  `desempeno` int(3) NOT NULL COMMENT 'Desempeño',
  `nivel` longtext CHARACTER SET latin1 COLLATE latin1_spanish_ci COMMENT 'Nivel',
  `recomendacion` longtext CHARACTER SET latin1 COLLATE latin1_spanish_ci COMMENT 'Recomendación',
  `creado_el` datetime DEFAULT NULL COMMENT 'Creado El',
  `creado_por` int(5) DEFAULT NULL COMMENT 'Creado Por',
  `actualizado_el` datetime DEFAULT NULL COMMENT 'Actualizado El',
  `actualizado_por` int(5) DEFAULT NULL COMMENT 'Actualizado Por',
  `eliminado_por` int(5) DEFAULT '0' COMMENT 'Eliminado Por',
  `eliminado_el` datetime DEFAULT NULL COMMENT 'Eliminado El',
  `estado` int(1) NOT NULL DEFAULT '1' COMMENT 'Estado'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


ALTER TABLE `nivel`
  ADD PRIMARY KEY (`id`),
  ADD KEY `grado` (`grado`),
  ADD KEY `asignatura` (`asignatura`),
  ADD KEY `periodo` (`periodo`),
  ADD KEY `competencia` (`competencia`),
  ADD KEY `desempeno` (`desempeno`);
  


ALTER TABLE `nivel`
  MODIFY `id` int(3) NOT NULL AUTO_INCREMENT COMMENT 'Id', AUTO_INCREMENT=1;

ALTER TABLE `nivel`
  ADD CONSTRAINT `nivel_ibfk_1` FOREIGN KEY (`grado`) REFERENCES `grado` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `nivel_ibfk_2` FOREIGN KEY (`asignatura`) REFERENCES `asignatura` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `nivel_ibfk_3` FOREIGN KEY (`periodo`) REFERENCES `periodo` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `nivel_ibfk_4` FOREIGN KEY (`competencia`) REFERENCES `competencia` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `nivel_ibfk_5` FOREIGN KEY (`desempeno`) REFERENCES `desempeno` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;
