<?php

namespace frontend\controllers;

use Yii;
use frontend\models\Tercero;
use backend\models\Grupo;
use backend\models\Academico;

use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * AcademicoController implements the CRUD actions for academico model.
 */
class AcademicoController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
        ];
    }


    public function actionView($id)
    {
        $model = $this->findModel($id);
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    
    public function actionCreate($tercero = NULL)
    {
        $model = new Academico();
        
        if(isset($tercero))
        {
            $tercero = Tercero::findOne(Yii::$app->request->get('tercero'));
        }
        else 
        {
            $tercero = new Tercero();
        }    

        if ($model->load(Yii::$app->request->post()) && $model->save()) {

               
            
            if($model->fecha_retiro !='')
            {
                $tercero = Tercero::findOne($model->estudiante);
                $tercero->estado = $model->motivo;    
                $tercero->update();
            }
            else
            {
                $tercero = Tercero::findOne($model->estudiante);
                $tercero->estado = '1';
                $tercero->update();
            } 
            return $this->redirect(['view', 'id' => $model->id]);  
            
        } else {
            return $this->render('create', [
                'model' => $model,
                'tercero' => $tercero,
            ]);
        }
    }

    public function actionGrupoxestudiante($id = NULL)
    {
        $academico = Academico::find()->where(['estudiante' => Yii::$app->request->get('tercero')])->one();
        return $academico->grupos->grupo;
    }

    public function actionGrupo($id = NULL)
    {
        $grupo = Grupo::findOne(Yii::$app->request->get('id'));
        return $grupo->grupo;
    }
    
    public function actionUpdate($id = NULL)
    {
        if(!isset($id))
        {
            $academico = Academico::find()->where(['estudiante' => Yii::$app->request->get('tercero')])->one();
            $id = $academico->id;
        }

        $model = $this->findModel($id);

        if ($model->loadAll(Yii::$app->request->post()) && $model->saveAll()) {
            
            if($model->fecha_retiro !='')
            {
                $tercero = Tercero::findOne($model->estudiante);
                $tercero->estado = $model->motivo;    
                $tercero->update();
            }
            else
            {
                $tercero = Tercero::findOne($model->estudiante);
                $tercero->estado = '1';
                $tercero->update();
            } 

            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    public function actionCambiar()
    {
        if (Yii::$app->request->isAjax) 
        {
            $id = Yii::$app->request->get('periodo');
            Periodo::updateAll(['habilitado' => 0], ['<', 'id', '6']);
        
            if($id <= 4)
            {   
                $model = $this->findModel($id);
                $model->habilitado = 1;
                $model->update(false);    
            }
            return $model->periodo;
        }
        else
        {
            $model = new Academico(['scenario'=>'cambiar']);

            //$model = Academico::find()->where(['eliminado_por' => 0])->andWhere(['is', 'fecha_retiro', new \yii\db\Expression('null')])->all();
                
            return $this->render('cambiar', [
                'model' => $model,
            ]);    
        }
    }


    public function actionDelete($id)
    {
        $this->findModel($id)->deleteWithRelated();

        return $this->redirect(['index']);
    }

    
    protected function findModel($id)
    {
        if (($model = academico::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
