<?php
namespace frontend\controllers;

use Yii;
use common\models\LoginForm;
use frontend\models\PasswordResetRequestForm;
use frontend\models\ResetPasswordForm;
use frontend\models\SignupForm;
use frontend\models\ContactForm;


use backend\models\Sede;
use backend\models\Agenda;
use backend\models\Blog;
use backend\models\Blogcategoria;
use backend\models\BlogSearch; 
use backend\models\Tercero;

use yii\base\InvalidParamException;
use yii\web\BadRequestHttpException;
use yii\web\NotFoundHttpException;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use kartik\mpdf\Pdf;
use yii\helpers\Url;
use yii\data\ActiveDataProvider;
use yii\web\Response;
use yii\db\Expression;


use dosamigos\qrcode\QrCode;
use kartik\widgets\Alert;

use edofre\fullcalendarscheduler\models\Event;
use edofre\fullcalendarscheduler\models\Resource;



/**
 * Site controller
 */
class AgendaController extends Controller
{

    public function actionIndex()
    {
        return $this->render('agenda');
    }


    public function actionResources($id)
    {
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

            $datos = [];
            //$childs = [];

            $dato = new Resource();
            $dato->id = 'E1';
            $dato->title = 'Eventos';
            $datos[] = $dato;

/*
            $grados = Grado::find()->all();

            foreach ($grados as $grado) 
            {
                
                $dato = new Resource();

                $dato->id = $grado->id;
                $dato->title = $grado->grado;
                
                $grupos = Grupo::find()->where(['grado' => $grado->id])->all();

                  foreach($grupos as $grupo)
                  {
                        $child = new Resource();
                        $child->id = 'g-'.$grupo->id;
                        $child->title = $grupo->grupo." - ".$grupo->sedes->sede;
                        $childs[] = $child;
                        $child = [];
                  } 
                  $dato->children = $childs;
                  $childs = []; 

                $datos[] = $dato;
            }
*/
         return $datos;      
    }


    public function actionEvents($id, $start, $end)
    {
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

            $eventos = [];

            $agendas = Agenda::find()->where(['estado' => 1])->andWhere(['publico' => '1'])->all();

            if(!empty($agendas))
            {
                foreach ($agendas as $agenda) 
                {                    
                           
                    $g = ($agenda->grupo == NULL) ? ['0'] : explode(',', $agenda->grupo);
                    
                    foreach ($g as $g2) 
                    {
                    
                        
                        $evento = new Event();
                        $evento->id = $agenda->id;
                        $evento->resourceId = 'E1';
                        $evento->title = $agenda->evento;
                        $evento->color = $agenda->color;
                        $evento->start = date('Y-m-d H:i:s',strtotime($agenda->fecha_inicio));
                        $evento->end = date('Y-m-d H:i:s',strtotime($agenda->fecha_fin));
                        $eventos[] = $evento;

                    }
                }
            }

        return $eventos;            
    }







}
