<?php

namespace frontend\controllers;

use Yii;
use backend\models\Oferente;
use backend\models\Anexo;
use backend\models\AnexoSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\FileHelper;
use yii\web\UploadedFile;
use yii\web\Response;
use yii\widgets\ActiveForm;

/**
 * AnexoController implements the CRUD actions for Anexo model.
 */
class AnexoController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
        ];
    }

    /**
     * Lists all Anexo models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new AnexoSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Anexo model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        $model = $this->findModel($id);
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    


    public function actionCreate($id = null)
    {
        if (($oferente = Oferente::findOne($id)) === null) {
            throw new NotFoundHttpException(Yii::t('app', 'El oferente no existe'));
        } 

        $anexos = Anexo::find()->where(['oferente' => $id])->andWhere(['eliminado_por' => '0'])->all();

        $model = new Anexo();

        if (Yii::$app->request->isAjax && $model->load(Yii::$app->request->post())) {
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ActiveForm::validate($model);
        }

        if ($model->loadAll(Yii::$app->request->post())) 
        {

            $carpeta = Yii::getAlias('@frontend') . "/web/uploads/oferentes/".$model->oferentes->id;
            
            if (!is_dir($carpeta)) 
            {
                if (FileHelper::createDirectory($carpeta, $mode = 0775, $recursive = true)) 
                {
                    Yii::$app->session->addFlash('mensaje', [
                        'tipo' => 'info',
                        'titulo' => 'Carpeta Creada',
                        'icono' => 'far info',
                        'mensaje' => 'La Carpeta de <b>'.$model->oferentes->razon_social.'</b> fue creada con éxito.',
                    ]);
                }
            }


            if($archivo = UploadedFile::getInstance($model, 'anexo'))
            {

                //$file->upload($carpeta);
                //$archivo = rand(10,100).'-'.$file;


                if (file_exists($carpeta."/".$archivo))
                {
                    unlink($carpeta."/".$archivo);
                }
                
                $archivo->saveAs($carpeta."/".$archivo);

                $model->anexo = $archivo;
            }


            if($model->save(false))
            {
                \Yii::$app->session->addFlash('mensaje', [
                    'tipo' => 'success',
                    'titulo' => 'Anexo Agregado',
                    'icono' => 'fa fa-check',
                    'mensaje' => 'El anexo <b>'.$model->tipos->tipo.'</b> se agregó éxitosamente.',
                ]);

                return $this->redirect(['oferente/index']);
            }
            else
            {
                \Yii::$app->session->addFlash('mensaje', [
                    'tipo' => 'danger',
                    'titulo' => 'Error Agregando Anexo',
                    'icono' => 'fa fa-times',
                    'mensaje' => 'El anexo <b>'.$model->tipos->tipo.'</b> no se agregó éxitosamente.',
                ]);
                return $this->redirect(['oferente/index']);
            }
            
                
        } 
        else 
        {
            return $this->renderAjax('create', [
                'model' => $model,
                'oferente' => $oferente,
                'anexos' => $anexos,
            ]);
        }
    }

    /**
     * Updates an existing Anexo model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->loadAll(Yii::$app->request->post()) && $model->saveAll()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing Anexo model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $model = Anexo::find()->where(['id' => $id])->one();

        $carpeta = Yii::getAlias('@frontend') . "/web/uploads/oferentes/".$model->oferentes->id;

        if (file_exists($carpeta."/".$model->anexo) && $model->anexo != NULL)
        {
            unlink($carpeta."/".$model->anexo);
        }

        $model->deleteWithRelated();

        return $this->redirect(['oferente/index']);
    }

    
    /**
     * Finds the Anexo model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Anexo the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Anexo::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
        }
    }
}
