<?php

namespace frontend\controllers;

use Yii;
use backend\models\Documento;
use backend\models\DocumentoSearch;
use backend\models\Documentocategoria;
use backend\models\DocumentocategoriaSearch;

use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\UploadedFile;
use yii\helpers\Url;
use yii\helpers\Html;
use yii\helpers\HtmlPurifier;
use yii\data\ActiveDataProvider;


/**
 * DocumentoController implements the CRUD actions for Documento model.
 */
class DocumentoController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
        ];
    }

    /**
     * Lists all Documento models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new DocumentoSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Documento model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        $model = $this->findModel($id);
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Documento model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Documento();

        if ($model->load(Yii::$app->request->post())) 
        {

            $carpeta = Yii::getAlias('@frontend') . "/web/documentos/".$model->categorias->carpeta;
            
            if (!is_dir($carpeta)) 
            {
                if (FileHelper::createDirectory($carpeta, $mode = 0775, $recursive = true)) 
                {
                    Yii::$app->session->addFlash('mensaje', [
                        'tipo' => 'info',
                        'titulo' => 'Carpeta Creada',
                        'icono' => 'far info',
                        'mensaje' => 'La Carpeta <b>'.$model->categorias->carpeta.'</b> fue creada con éxito.',
                    ]);
                }
            }


            if($file = UploadedFile::getInstance($model, 'archivo'))
            {

                //$file->upload($carpeta);
                $archivo = rand(10,100).'-'.$file;
                
                $file->saveAs($carpeta.'/'.$archivo);

                $model->archivo = $archivo;
            }
            $model->save();

            return $this->redirect(['index']);
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing Documento model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    
    public function actionCategorias()
    {
        
        $categorias = Documentocategoria::find()->where(['is', 'padre', new \yii\db\Expression('null')])->andWhere(['estado' => '1'])->all();
        
        if (count($categorias) > 0) 
        {

            return $this->render('categorias', [
                'categorias' => $categorias
            ]);

        } else {
            throw new NotFoundHttpException(Yii::t('app', 'No hay categorías'));
        }
    }

    public function actionCategoria($id = null)
    {
        if($id == null)
        {
            $search = Yii::$app->request->get('DocumentoSearch');
            $id = $search['categoria'];
        }
           
        
        if (($model = Documentocategoria::findOne($id)) !== null) {


            /*
            $dataProvider = new ActiveDataProvider([
                'query' => $searchModel->search(Yii::$app->request->queryParams),
                'pagination' => [
                    'pageSize' => 10,
                ],
            ]);
            */


            
            $searchModel = new DocumentoSearch();
            $dataProvider = $searchModel->search(['DocumentoSearch'=>['categoria' => $id]]);
            $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
            
            $dataProvider->pagination->pagesize = 10;
            

/*
            $dataProvider = new ActiveDataProvider([
                'query' => Documento::find()->where(['categoria' => $id])->andWhere(['estado' => 1]),
                'pagination' => [
                    'pageSize' => 10,
                ],
                'sort' => [
                    'defaultOrder' => [
                        'created_at' => SORT_DESC,
                        'title' => SORT_ASC,
                    ]
                ],
            ]);
            */

            return $this->render('categoria', [
                'model' => $model,
                'dataProvider' => $dataProvider,
                'searchModel' => $searchModel,
            ]);

        } else {
            throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
        }
    }

    public function actionDownload($id)
    {

        if (($model = Documento::findOne($id)) !== null) {

            $model->descargas = $model->descargas + 1;
            $model->update(false);

            //$file = Yii::getAlias('@web') . "/documentos/".$model->categorias->carpeta.'/'.$model->archivo;

            //$file = Html::encode("/documentos/".$model->categorias->carpeta.'/'.$model->archivo);

            $file = HtmlPurifier::process("/documentos/".$model->categorias->carpeta.'/'.$model->archivo);

            //echo "Archivo: ".$file;

            header("Location: ".Url::to([$file]));
            exit;
        
        } else {
            throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
        }       
        
    }


    public function actionDelete($id)
    {
        $this->findModel($id)->deleteWithRelated();

        return $this->redirect(['index']);
    }

    
    /**
     * Finds the Documento model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Documento the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Documento::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
        }
    }
}
