<?php

namespace frontend\controllers;

use Yii;
use backend\models\Pqrsd;
use frontend\models\PqrsdSearch;
use frontend\models\PqrsdForm;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\UploadedFile;



class PqrsdController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
        ];
    }


    public function actionIndex()
    {
        if (!Yii::$app->user->isGuest) {
                
            $searchModel = new PqrsdSearch();
            $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

            return $this->render('index', [
                'searchModel' => $searchModel,
                'dataProvider' => $dataProvider,
            ]);

        }
        else
        {
            $model = new PqrsdForm();

            if ($model->load(Yii::$app->request->post())) {
                
                if(($pqr = Pqrsd::find()->where(['id' => $model->id])->andWhere(['email' => $model->email])->one()) !== null)
                {
                    return $this->redirect(['view', 'id' => $pqr->id]);    
                }
                else
                {
                    throw new NotFoundHttpException(Yii::t('app', 'La PQRSD con esos parámetros no existe.'));
                }
                
            } else {
                return $this->render('buscar', [
                'model' => $model
            ]);
            }

            
            
            
        }

        
    }

    public function actionView($id)
    {
        $model = $this->findModel($id);
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }


    public function actionReceived($id)
    {
        $model = $this->findModel($id);
        return $this->render('received', [
            'model' => $this->findModel($id),
        ]);
    }

    public function actionCreate()
    {
        if (Yii::$app->user->isGuest) {
            return $this->redirect(['site/login']);
        }

        $model = new Pqrsd();
        $model->scenario = 'registrado';
        $model->email = Yii::$app->user->identity->email;

        if ($model->loadAll(Yii::$app->request->post())) 
        {

            $archivos = [];
                
            foreach (UploadedFile::getInstances($model, 'adjunto_solicitud') as $adjunto) {
                list($drive) = Yii::$app->createController('drive');
                $archivos[] =  serialize($drive->actionSubir(Yii::$app->params['drive-pqrsd'],$adjunto));
            }

            $model->adjunto_solicitud = implode(',',$archivos); 

            if($model->saveAll())
            {
                return $this->redirect(['view', 'id' => $model->id]);    
            }
            
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    public function actionAnonymous()
    {
        

        $model = new Pqrsd();
        $model->scenario = 'anonymous';
        

        if ($model->loadAll(Yii::$app->request->post())) 
        {

            $archivos = [];
                
            foreach (UploadedFile::getInstances($model, 'adjunto_solicitud') as $adjunto) {
                list($drive) = Yii::$app->createController('drive');
                $archivos[] =  serialize($drive->actionSubir(Yii::$app->params['drive-pqrsd'],$adjunto));
            }

            $model->adjunto_solicitud = implode(',',$archivos); 

            if($model->saveAll())
            {
                return $this->redirect(['view', 'id' => $model->id]);    
            }

            
        } else {
            return $this->render('anonymous', [
                'model' => $model,
            ]);
        }
    }


    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->loadAll(Yii::$app->request->post()) && $model->saveAll()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }


    public function actionDelete($id)
    {
        $this->findModel($id)->deleteWithRelated();

        return $this->redirect(['index']);
    }

 
    protected function findModel($id)
    {
        if (($model = Pqrsd::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
        }
    }
}
