<?php

namespace frontend\controllers;

use yii;
use yii\web\Controller;

use backend\models\Asignatura;
use backend\models\Area;
use backend\models\Grupo;
use backend\models\Grado;
use backend\models\Periodo;
use backend\models\Estandar;
use backend\models\Carga;
use backend\models\Competencia;
use backend\models\Municipio;
use backend\models\Barrio;
use backend\models\Desempeno;
use backend\models\Tercero;
use backend\models\Terceroestado;
use backend\models\Resguardo;
use backend\models\LanzadorForm;
use backend\models\BloquearboletinesForm;

//<script src="https://cdn.ckeditor.com/ckeditor5/18.0.0/classic/ckeditor.js"></script>

class PublicaController extends Controller
{

    public function Municipios($departamento) {
        $out = [];
        if (isset($departamento)) {
            $id = end($departamento);
            $list = Municipio::find()->andWhere(['departamento'=>$id])->asArray()->all();
            $selected  = null;
            if ($id != null && count($list) > 0) {
                $selected = '';
                foreach ($list as $i => $data) {
                    $out[] = ['id' => $data['id'], 'name' => $data['nombre']];
                    if ($i == 0) {
                        $selected = $data['id'];
                    }
                }
                // Shows how you can preselect a value
                return Json_encode(['output' => $out, 'selected'=>$selected]);
            }
        }
        return Json_encode(['output' => '', 'selected'=>'']);
    }

    public function Barrios($municipio) {
        $out = [];
        if (isset($municipio)) {
            $id = end($municipio);
            $list = Barrio::find()->where(['municipio' => $id])->orderBy(['nombre' => SORT_ASC])->asArray()->all();
            $selected  = null;
            if ($id != null && count($list) > 0) {
                $selected = '';
                foreach ($list as $i => $data) {
                    $out[] = ['id' => $data['id'], 'name' => $data['nombre']];
                    if ($i == 0) {
                        $selected = $data['id'];
                    }
                }
                // Shows how you can preselect a value
                return Json_encode(['output' => $out, 'selected'=>$selected]);
            }
        }
        return Json_encode(['output' => '', 'selected'=>'']);
    }
 
 
    public function Resguardos($departamento) {
        $out = [];
        if (isset($departamento)) {
            $id = end($departamento);
            $list = Resguardo::find()->andWhere(['departamento'=>$id])->asArray()->all();
            $selected  = null;
            if ($id != null && count($list) > 0) {
                $selected = '';
                foreach ($list as $i => $data) {
                    $out[] = ['id' => $data['id'], 'name' => $data['resguardo']];
                    if ($i == 0) {
                        //$selected = $data['id'];
                    }
                }
                // Shows how you can preselect a value
                return Json_encode(['output' => $out, 'selected'=>$selected]);
            }
        }
        return Json_encode(['output' => '', 'selected'=>'']);
    }

    public function Filesize($bytes, $decimales = 2)
    {
        $size = array('B','kB','MB','GB','TB','PB','EB','ZB','YB');
        $factor = floor((strlen($bytes) - 1) / 3);
        return sprintf("%.{$decimales}f ", $bytes / pow(1024, $factor)) . @$size[$factor];
    }    

}
