<?php
namespace frontend\controllers;

use Yii;
use common\models\LoginForm;
use frontend\models\PasswordResetRequestForm;
use frontend\models\ResetPasswordForm;
use frontend\models\SignupForm;
use frontend\models\ContactForm;

use backend\models\Grado;
use backend\models\Grupo;
use backend\models\Agenda;
use backend\models\Blog;
use backend\models\Blogcategoria;
use backend\models\BlogSearch; 

use yii\base\InvalidParamException;
use yii\web\BadRequestHttpException;
use yii\web\NotFoundHttpException;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use kartik\mpdf\Pdf;
use yii\helpers\Url;
use yii\data\ActiveDataProvider;


use dosamigos\qrcode\QrCode;
use kartik\widgets\Alert;

use edofre\fullcalendarscheduler\models\Event;
use edofre\fullcalendarscheduler\models\Resource;



/**
 * Site controller
 */
class SiteController extends Controller
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'only' => ['logout', 'signup'],
                'rules' => [
                    [
                        'actions' => ['signup'],
                        'allow' => true,
                        'roles' => ['?'],
                    ],
                    [
                        'actions' => ['logout'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'logout' => ['post'],
                ],
            ],
        ];
    }

    /**
     * @inheritdoc
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
            'captcha' => [
                'class' => 'yii\captcha\CaptchaAction',
                'fixedVerifyCode' => YII_ENV_TEST ? 'testme' : null,
            ],
        ];
    }

    /**
     * Displays homepage.
     *
     * @return mixed
     */


    public function actionIndex()
    {
        $searchModel = new BlogSearch();
        $searchModel->inicio = '1';
        $searchModel->search(Yii::$app->request->queryParams);
/*
        $dataProvider = new ActiveDataProvider([
            'query' => Blog::find()->where(['inicio' => '0'])->orderBy(['creado_el' => SORT_DESC]),
            'pagination' => [
                'pageSize' => 20,
            ],
        ]);    
*/  
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        $dataProvider->pagination->pageSize = 3;

        $categorias = Blogcategoria::find()->where(['estado'=> '1'])->andWhere(['>','id', '1'])->all();

        $populares = Blog::find()->where(['estado' => 1, 'aprobado' => 1])->andWhere(['>','categoria', '1'])->orderBy(['visto' => SORT_ASC])->limit(5)->all();

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'categorias' => $categorias,
            'populares' => $populares,
        ]); 
    }

    public function actionInstitucional()
    {
  
        return $this->render('institucional', [
            //'model' => $model,
        ]);
    }

    public function actionBlog($categoria = NULL)
    {
        if(Yii::$app->request->get('categoria') != "")
        {
            $model = Blog::find()
                        ->where(['estado' => 1, 'aprobado' => 1])
                        ->andWhere(['categoria' => Yii::$app->request->get('categoria')])
                        ->all();
        }
        else
        {
            $model = Blog::find()->where(['estado' => 1, 'aprobado' => 1])->andWhere(['>','categoria', '1'])->all();    
        }    
        
        return $this->render('blog', [
            'model' => $model,
            'categoria' => Yii::$app->request->get('categoria'), 
        ]);
    }

    public function actionView($id)
    {
        if (($model = Blog::find($id)->where(['id' => $id, 'estado' => 1, 'aprobado' => 1])->one()) !== null) {    
            $model->visto = $model->visto + 1;
            $model->update(false);

            $categorias = Blogcategoria::find()->where(['estado'=> '1'])->andWhere(['>','id', '1'])->all();

            $populares = Blog::find()->where(['estado' => 1, 'aprobado' => 1])->andWhere(['>','categoria', '1'])->orderBy(['visto' => SORT_ASC])->limit(5)->all();

            return $this->render('view', [
                'model' => $model,
                'categorias' => $categorias,
                'populares' => $populares,
            ]);
        } 
        else 
        {
            throw new NotFoundHttpException('El artículo no existe o no está aprobado para su publicación.');
        }
    }

    public function actionGaleria()
    {
  
        return $this->render('galeria', [
            //'model' => $model,
        ]);
    }

    public function actionLogin()
    {
        if (!\Yii::$app->user->isGuest) {
            return $this->goAdmin();
        }

        $model = new LoginForm();
        if ($model->load(Yii::$app->request->post()) && $model->login()) {
            return $this->goBack();
        } else {
            return $this->render('login', [
                'model' => $model,
            ]);
        }
    }

    public function actionLogout()
    {
        Yii::$app->user->logout();

        return $this->goHome();
    }

    public function actionContacto()
    {
        $model = new ContactForm();
        if ($model->load(Yii::$app->request->post()) && $model->validate()) {
            if ($model->sendEmail(Yii::$app->params['adminEmail'])) {
                Yii::$app->session->setFlash('success', 'Gracias por contactarnos. Nosotros responderemos a la mayor brevedad posible.');
            } else {
                Yii::$app->session->setFlash('error', 'Se produjo un error al enviar el correo electrónico.');
            }

            return $this->refresh();
        } else {
            return $this->render('contacto', [
                'model' => $model,
            ]);
        }
    }

    public function actionSignup()
    {
        $model = new SignupForm();
        if ($model->load(Yii::$app->request->post())) {
            if ($user = $model->signup()) {
                if (Yii::$app->getUser()->login($user)) {
                    return $this->goHome();
                }
            }
        }

        return $this->render('signup', [
            'model' => $model,
        ]);
    }

    public function actionRequestPasswordReset()
    {
        $model = new PasswordResetRequestForm();
        if ($model->load(Yii::$app->request->post()) && $model->validate()) {
            if ($model->sendEmail()) {
                Yii::$app->session->setFlash('success', 'Check your email for further instructions.');

                return $this->goHome();
            } else {
                Yii::$app->session->setFlash('error', 'Sorry, we are unable to reset password for email provided.');
            }
        }

        return $this->render('requestPasswordResetToken', [
            'model' => $model,
        ]);
    }

    public function actionResetPassword($token)
    {
        try {
            $model = new ResetPasswordForm($token);
        } catch (InvalidParamException $e) {
            throw new BadRequestHttpException($e->getMessage());
        }

        if ($model->load(Yii::$app->request->post()) && $model->validate() && $model->resetPassword()) {
            Yii::$app->session->setFlash('success', 'New password was saved.');

            return $this->goHome();
        }

        return $this->render('resetPassword', [
            'model' => $model,
        ]);
    }



    public function actionAgenda()
    {

        return $this->render('agenda');
    }

    public function actionResources($id)
    {
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

            $datos = [];
            $childs = [];

            $dato = new Resource();
            $dato->id = 'g-0';
            $dato->title = 'Todo el Colegio';
            $datos[] = $dato;

            $grados = Grado::find()->all();

            foreach ($grados as $grado) 
            {
                
                $dato = new Resource();

                $dato->id = $grado->id;
                $dato->title = $grado->grado;
                
                $grupos = Grupo::find()->where(['grado' => $grado->id])->all();

                  foreach($grupos as $grupo)
                  {
                        $child = new Resource();
                        $child->id = 'g-'.$grupo->id;
                        $child->title = $grupo->grupo." - ".$grupo->sedes->sede;
                        $childs[] = $child;
                        $child = [];
                  } 
                  $dato->children = $childs;
                  $childs = []; 

                $datos[] = $dato;
            }

         return $datos;      
    }

    public function actionEvents($id, $start, $end)
    {
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

            $eventos = array();

            $agendas = Agenda::find()->where(['publico' => 1])->all();

            if(!empty($agendas))
            {
                foreach ($agendas as $agenda) 
                {                    
                           
                    $g = ($agenda->grupo == NULL) ? ['0'] : explode(',', $agenda->grupo);
                    
                    foreach ($g as $g2) 
                    {
                    
                        
                        $evento = new Event();
                        $evento->id = $agenda->id;
                        $evento->resourceId = 'g-'.$g2;
                        $evento->title = $agenda->evento;
                        $evento->color = $agenda->color;
                        $evento->start = date('Y-m-d\TH:i:s',strtotime($agenda->fecha_inicio));
                        $evento->end = date('Y-m-d\TH:i:s',strtotime($agenda->fecha_fin));
                        $eventos[] = $evento;
                    }
                }
            }

        return $eventos;            
    }

}
