<?php
namespace frontend\controllers;

use Yii;
use common\models\LoginForm;
use frontend\models\PasswordResetRequestForm;
use frontend\models\ResetPasswordForm;
use frontend\models\SignupForm;
use frontend\models\ContactForm;


use backend\models\Sede;
use backend\models\Agenda;
use backend\models\Blog;
use backend\models\Blogcategoria;
use backend\models\BlogSearch; 
use backend\models\Tercero;

use yii\base\InvalidParamException;
use yii\web\BadRequestHttpException;
use yii\web\NotFoundHttpException;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use kartik\mpdf\Pdf;
use yii\helpers\Url;
use yii\data\ActiveDataProvider;
use yii\web\Response;
use yii\db\Expression;


use dosamigos\qrcode\QrCode;
use kartik\widgets\Alert;

use edofre\fullcalendarscheduler\models\Event;
use edofre\fullcalendarscheduler\models\Resource;



/**
 * Site controller
 */
class SiteController extends Controller
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'only' => ['logout', 'signup'],
                'rules' => [
                    [
                        'actions' => ['signup'],
                        'allow' => true,
                        'roles' => ['?'],
                    ],
                    [
                        'actions' => ['logout'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'logout' => ['post'],
                ],
            ],
        ];
    }

    /**
     * @inheritdoc
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
            'captcha' => [
                'class' => 'yii\captcha\CaptchaAction',
                'fixedVerifyCode' => YII_ENV_TEST ? 'testme' : null,
            ],
        ];
    }

    /**
     * Displays homepage.
     *
     * @return mixed
     */


    public function actionIndex()
    {
        $searchModel = new BlogSearch();
        $searchModel->inicio = '1';
        $searchModel->search(Yii::$app->request->queryParams);

        $dataProvider = new ActiveDataProvider([
            'query' => Blog::find()->where(['estado' => 1, 'aprobado' => 1])->andWhere(['>','categoria', '1'])->andWhere(['eliminado_por' => 0])->orderBy(['creado_el' => SORT_DESC]),
            'pagination' => [
                'pageSize' => 4,
            ],
        ]);    
 
        //$dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        //$dataProvider->pagination->pageSize = 3;

        $categorias = Blogcategoria::find()->where(['estado'=> '1'])->andWhere(['>','id', '1'])->all();

        $populares = Blog::find()->where(['estado' => 1, 'aprobado' => 1])->andWhere(['>','categoria', '1'])->andWhere(['eliminado_por' => 0])->orderBy(['visto' => SORT_ASC])->limit(5)->all();

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'categorias' => $categorias,
            'populares' => $populares,
        ]); 

    }

    public function actionInstitucional()
    {
  
        return $this->render('institucional', [
            //'model' => $model,
        ]);
    }


    public function actionPanel()
    {
        if (Yii::$app->user->isGuest) {
            return $this->redirect(['site/login']);
        }

        $model = Tercero::find()->where(['creado_por' => Yii::$app->user->identity->id])->one();

        $sede = Sede::find()->where(['principal' => "1"])->one();

        return $this->render('panel', [
            'model' => $model,
            'sede' => $sede,
        ]);
    }


    public function actionBlog($categoria = NULL)
    {
        if(Yii::$app->request->get('categoria') != "")
        {
            $model = Blog::find()
                        ->where(['estado' => 1, 'aprobado' => 1])
                        ->andWhere(['categoria' => Yii::$app->request->get('categoria')])
                        ->andWhere(['eliminado_por' => 0])
                        ->all();
        }
        else
        {
            $model = Blog::find()->where(['estado' => 1, 'aprobado' => 1])->andWhere(['>','categoria', '1'])->andWhere(['eliminado_por' => 0])->all();    
        }    
        
        return $this->render('blog', [
            'model' => $model,
            'categoria' => Yii::$app->request->get('categoria'), 
        ]);
    }

    public function actionView($id)
    {
        $sede = Sede::find()->where(['principal' => "1"])->one();

        if (($model = Blog::find($id)->where(['id' => $id, 'estado' => 1, 'aprobado' => 1])->andWhere(['eliminado_por' => 0])->one()) !== null) {    
            $model->visto = $model->visto + 1;
            $model->update(false);

            if($id != 4)
            {
                $categorias = Blogcategoria::find()->where(['estado'=> '1'])->andWhere(['>','id', '1'])->andWhere(['eliminado_por' => 0])->all();

                $populares = Blog::find()->where(['estado' => 1, 'aprobado' => 1])->andWhere(['>','categoria', '1'])->andWhere(['eliminado_por' => 0])->orderBy(['visto' => SORT_ASC])->limit(5)->all();

                return $this->render('view', [
                    'model' => $model,
                    'categorias' => $categorias,
                    'populares' => $populares,
                    'sede' => $sede,
                ]);    
            }
            else
            {
                return $this->render('covid-19', [
                    'model' => $model,
                    'sede' => $sede,
                ]);        
            }
            
            
        } 
        else 
        {
            throw new NotFoundHttpException('El artículo no existe o no está aprobado para su publicación.');
        }
    }

    public function actionGaleria()
    {
  
        return $this->render('galeria', [
            //'model' => $model,
        ]);
    }


    public function actionLogin()
    {
        if (!\Yii::$app->user->isGuest) {
            //return $this->goAdmin();
            return $this->redirect(['site/panel']);
        }

        $model = new LoginForm();
        if ($model->load(Yii::$app->request->post()) && $model->login()) {
            //return $this->goBack();
            return $this->redirect(['site/panel']);
        } else {
            return $this->render('login', [
                'model' => $model,
            ]);
        }
    }


    public function actionLogout()
    {
        Yii::$app->user->logout();

        return $this->goHome();
    }


    public function actionContacto()
    {
        $sede = Sede::find()->where(['principal' => "1"])->one();

        $model = new ContactForm();
        if ($model->load(Yii::$app->request->post()) && $model->validate()) {
            if ($model->sendEmail($sede->email_atencion_ciudadano)) {
                    Yii::$app->session->addFlash('mensaje', [
                        'tipo' => 'info',
                        'titulo' => 'Mensaje Enviado',
                        'icono' => 'far info',
                        'mensaje' => 'Gracias por contactarnos. Nosotros responderemos a la mayor brevedad posible.',
                    ]);

                    return $this->goHome();

            } else {

                Yii::$app->session->addFlash('mensaje', [
                        'tipo' => 'error',
                        'titulo' => 'No se pudo entregar el mensaje',
                        'icono' => 'far times',
                        'mensaje' => 'No se pudo entregar el mensaje, intente nuevamente más tarde.',
                    ]);
                return $this->goHome();
            }

            return $this->refresh();
        } else {
            return $this->render('contacto', [
                'model' => $model,
            ]);
        }
    }


    public function actionSignup()
    {
        $model = new SignupForm();
        if ($model->load(Yii::$app->request->post())) {
            if ($user = $model->signup()) {
                if (Yii::$app->getUser()->login($user)) {
                    //return $this->goHome();
                    return $this->redirect(['tercero/create']);
                }
            }
        }

        return $this->render('signup', [
            'model' => $model,
        ]);
    }


    public function actionRequestPasswordReset()
    {
        $model = new PasswordResetRequestForm();
        if ($model->load(Yii::$app->request->post()) && $model->validate()) {
            if ($model->sendEmail()) {

                Yii::$app->session->addFlash('mensaje', [
                        'tipo' => 'info',
                        'titulo' => 'Mensaje Enviado',
                        'icono' => 'far info',
                        'mensaje' => 'Revise su correo electrónico para obtener más instrucciones.',
                    ]);

                return $this->goHome();
            } else {
                Yii::$app->session->addFlash('mensaje', [
                        'tipo' => 'danger',
                        'titulo' => 'Error Enviando Mensaje',
                        'icono' => 'far times',
                        'mensaje' => 'Lo sentimos, no podemos restablecer la contraseña del correo electrónico proporcionado.',
                    ]);
                
            }
        }

        return $this->render('requestPasswordResetToken', [
            'model' => $model,
        ]);
    }


    public function actionResetPassword($token)
    {
        try {
            $model = new ResetPasswordForm($token);
        } catch (InvalidParamException $e) {
            throw new BadRequestHttpException($e->getMessage());
        }

        if ($model->load(Yii::$app->request->post()) && $model->validate() && $model->resetPassword()) {
            Yii::$app->session->addFlash('mensaje', [
                        'tipo' => 'info',
                        'titulo' => 'Contraseña Reestablecida',
                        'icono' => 'far info',
                        'mensaje' => 'Su nueva contraseña fue almacenada.',
                    ]);

            return $this->goHome();
        }

        return $this->render('resetPassword', [
            'model' => $model,
        ]);
    }



    public function actionLista($q = null, $id = null) 
    {
        Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
        $out = ['results' => ['id' => '', 'text' => '']];
        if (!is_null($q)) {

            /*
                $data = Blog::find()->select(['id', new Expression("CONCAT(primer_nombre,' ', segundo_nombre,' ',primer_apellido,' ',segundo_apellido) as text")])
                    ->Where(['tercero.tipo_tercero' => '1'])
                    //->andWhere(['<', 'tercero.estado', '3'])
                    ->Where(['like', 'primer_nombre', $q])
                    ->orWhere(['like', 'segundo_nombre', $q])
                    ->orWhere(['like', 'primer_apellido', $q])
                    ->orWhere(['like', 'segundo_apellido', $q])
                    ->orderBy('primer_apellido')
                    ->asArray()
                    ->all();
            */

            $data = Blog::find()->select(['id', new Expression("titulo as text")])
                    ->Where(['eliminado_por' => '0'])
                    //->andWhere(['<', 'tercero.estado', '3'])
                    ->Where(['like', 'titulo', $q])
                    ->orWhere(['like', 'introduccion', $q])
                    ->orWhere(['like', 'contenido', $q])
                    ->orderBy(['creado_el' => SORT_DESC])
                    ->asArray()
                    ->all();
            
            /*$query = new Query;
            $query->select(new Expression("id, CONCAT(primer_nombre,' ', segundo_nombre,' ',primer_apellido,' ',segundo_apellido) as text"))
                ->from('tercero')
                ->Where(['like', 'primer_nombre', $q])
                ->orWhere(['like', 'segundo_nombre', $q])
                ->orWhere(['like', 'primer_apellido', $q])
                ->orWhere(['like', 'segundo_apellido', $q])
                ->orderBy('primer_apellido')        
                ->limit(20);
            $command = $query->createCommand();
            $data = $command->queryAll();
              */ 

            $out['results'] = array_values($data);
        }
        elseif ($id > 0) {
            $out['results'] = ['id' => $id, 'text' => Tercero::findOne($id)->primer_apellido];
        }
        return $out;
    }



    public function actionBuscar($id)
    {

        if (($model = Blog::find()->where(['id' => $id, 'estado' => 1, 'aprobado' => 1])->one()) !== null) 
        {    
            
        } 
        else 
        {
            throw new NotFoundHttpException('El artículo no existe o no está aprobado para su publicación.');
        }
    }



}
