<?php

namespace frontend\models;

use Yii;
use yii\base\Model;

/**
 * ContactForm is the model behind the contact form.
 */
class ContactForm extends Model
{
    public $name;
    public $email;
    public $subject;
    public $body;
    public $movil;
    public $verifyCode;

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            // name, email, subject and body are required
            [['name', 'email', 'subject', 'body', 'movil'], 'required'],
            // email has to be a valid email address
            ['email', 'email'],
            // verifyCode needs to be entered correctly
            ['verifyCode', 'captcha'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'name' => 'Nombres y Apellidos',
            'email' => 'Correo Electrónico',
            'subject' => 'Asunto',
            'body' => 'Mensaje',
            'movil' => 'Celular',
            'verifyCode' => 'Verification Code',
        ];
    }

    /**
     * Sends an email to the specified email address using the information collected by this model.
     *
     * @param  string  $email the target email address
     * @return boolean whether the email was sent
     */
    public function sendEmail($email)
    {

        return Yii::$app->mailer->compose()
                ->setFrom([$this->email => $this->name])
                ->setTo($email) //
                //->setCc(\Yii::$app->params['adminEmail']) //
                ->setSubject('Desde Web: '.$this->subject)
                ->setHtmlBody('Nombres y Apellidos: '. $this->name.' <br> Celular: '.$this->movil.' <br> '. $this->body)
                ->send();
    }
}
