<?php

namespace frontend\models;

use Yii;


class Matricula extends \yii\db\ActiveRecord
{
    use \mootensai\relation\RelationTrait;

    public function relationNames()
    {
        return [
            'estudiantes',
            'grupos',
            'especialidades'
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['estudiante', 'grupo'], 'required'],
            [['estudiante', 'grupo', 'especialidad', 'estado'], 'integer'],
            [['fecha_matricula'], 'safe']
        ];
    }


    public static function tableName()
    {
        return 'matricula';
    }

    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Id'),
            'estudiante' => Yii::t('app', 'Estudiante'),
            'grupo' => Yii::t('app', 'Grupo'),
            'especialidad' => Yii::t('app', 'Especialidad'),
            'fecha_matricula' => Yii::t('app', 'Fecha de Matricula'),
            'estado' => Yii::t('app', 'Estado'),
        ];
    }
    
    public function getEstudiantes()
    {
        return $this->hasOne(\backend\models\Tercero::className(), ['id' => 'estudiante']);
    }
        
    public function getGrupos()
    {
        return $this->hasOne(\backend\models\Grupo::className(), ['id' => 'grupo']);
    }
        
    public function getEspecialidades()
    {
        return $this->hasOne(\backend\models\Especialidad::className(), ['id' => 'especialidad']);
    }
    
}
