<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
use kartik\switchinput\SwitchInput;
use kartik\widgets\DatePicker;
use kartik\widgets\Select2;

use backend\models\Tercero;
use backend\models\Grupo;

?>
    <?php $form = ActiveForm::begin([
        'action' => ['index'],
        'method' => 'get',
    ]); ?>


<div class="col-sm-12">
    <div class="col-sm-6">
        <?= $form->field($model, 'estudiante')->widget(Select2::classname(), [
            'data' => ArrayHelper::map(Tercero::find()->select(['id', new \yii\db\Expression("CONCAT(primer_nombre,' ', segundo_nombre,' ',primer_apellido,' ',segundo_apellido) as nombre")])->where(['estado' => '1', 'tipo_tercero' => '1'])->orderBy('id')->asArray()->all(), 'id', 'nombre'),
            'options' => ['placeholder' => 'Seleccione el Estudiante'],
            'pluginOptions' => [
                'allowClear' => true
            ],
        ]) ?>

    </div>       
    <div class="col-sm-6">
        <?= $form->field($model, 'grupo')->widget(Select2::classname(), [
            'data' => ArrayHelper::map(Grupo::find()->where(['estado' => '1'])->orderBy('id')->asArray()->all(), 'id', 'grupo'),
            'options' => ['placeholder' => 'Seleccione el Grupo'],
            'pluginOptions' => [
                'allowClear' => true
            ],
        ]) ?>
    </div>
    <div class="col-sm-3">
        <?= $form->field($model, 'fecha_matricula')->widget(DatePicker::classname(), [
            'options' => ['placeholder' => 'Seleccione la Fecha de Matrícula'],
            'type' => DatePicker::TYPE_COMPONENT_APPEND,
            'pluginOptions' => [
                'autoclose' => true,
                'format' => 'yyyy-mm-dd',
                'todayHighlight' => true            ]
        ]) ?>
    </div>
    <div class="col-sm-3">
        <?= $form->field($model, 'fecha_retiro')->widget(DatePicker::classname(), [
            'options' => ['placeholder' => 'Seleccione la Fecha de Retiro'],
            'type' => DatePicker::TYPE_COMPONENT_APPEND,
            'pluginOptions' => [
                'autoclose' => true,
                'format' => 'yyyy-mm-dd',
                'todayHighlight' => true            ]
        ]) ?>
    </div>

    <div class="col-sm-3">     

        <?= $form->field($model, 'aprobo')->widget(SwitchInput::classname(), ['pluginOptions' => [
            'size' => 'medium',
            'onColor' => 'success',
            'offColor' => 'danger',
            'onText'=>'Si',
            'offText'=>'No'
        ]]) 
        ?>
    </div>    
    <div class="col-sm-12">
        <?= Html::submitButton('Buscar', ['class' => 'btn btn-success']) ?>
        <?= Html::resetButton('Limpiar', ['class' => 'btn btn-default']) ?>
    </div>    
</div>

    <?php ActiveForm::end(); ?>
 
<div style="clear:both">  
        
</div>        
