<?php

/* @var $this yii\web\View */
/* @var $searchModel backend\models\PeriodoSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

use yii\helpers\Html;
use yii\bootstrap\Progress;
use yii\helpers\Url;
use kartik\widgets\ActiveForm;
use kartik\tabs\TabsX;
use kartik\switchinput\SwitchInput;
use kartik\widgets\Select2;
use yii\helpers\ArrayHelper;
use yii\db\Expression;

use backend\models\Tercero;
use backend\models\Grupo;

$this->title = 'Cambiar Periodo';
$this->params['breadcrumbs'][] = ['label' => 'Periodos', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

$this->registerJs("$('#academico-estudiante').change(function(){
    
    $.ajax({
            type: 'GET',
            url: '". Url::to(['grupoxestudiante'])."',
            timeout: 20000,

            data: {tercero : this.value},
            success: function (data) {
                

                $('#actual').html(data);   
                
            },
            error: function(request, status, err) {
                if (status == 'timeout') {
                    //timeout -> reload the page and try again
                        //$('#'+valor).html(\"<i class='fas fa-times text-danger'></i>\");
                    console.log('timeout');
                    //window.location.reload();
                } else {
                        //$('#'+valor).html(\"<span class='text-danger'>\"+ err + \"</span>\");
                    //another error occured  
                    //alert('error: ' + request + status + err);
                    console.log('error: ' + request + status + err);
                }
            }
    
        }); 

});


$('#academico-grupo_new').change(function(){
    
    $('#Btnaplicar').removeAttr('disabled');

    tercero = $('#academico-estudiante').val();
    grupo_new = $('#academico-grupo_new').val();
    grupo_old = $('#academico-grupo_old').val();


    if (tercero != '' && grupo_new != '')
    {
        $('#Btnaplicar').removeAttr('disabled');
    }
    else
    {
        $('#Btnaplicar').attr('disabled', false); 
    }
    
    $.ajax({
            type: 'GET',
            url: '". Url::to(['grupo'])."',
            timeout: 20000,

            data: {id : this.value},
            success: function (data) {
                

                $('#nuevo').html(data);   
                
            },
            error: function(request, status, err) {
                if (status == 'timeout') {
                    //timeout -> reload the page and try again
                        //$('#'+valor).html(\"<i class='fas fa-times text-danger'></i>\");
                    console.log('timeout');
                    //window.location.reload();
                } else {
                        //$('#'+valor).html(\"<span class='text-danger'>\"+ err + \"</span>\");
                    //another error occured  
                    //alert('error: ' + request + status + err);
                    console.log('error: ' + request + status + err);
                }
            }
    
        }); 

});


"
);

?>  

    <?php $form = ActiveForm::begin([
        'type' => ActiveForm::TYPE_VERTICAL,
        'enableClientValidation' => false,
        'enableAjaxValidation' => true,
        'options' => ['class' => 'main-task-form',
                      'id' => 'formulario',
                    ]
    ]); ?>


<div class="row">
    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
        <?= Html::img('@web/images/sonic-tiempo.png', ['class'=>'img-responsive']); ?>
    </div>
    <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
        <div class="row">
            <div class="col-lg-12 col-md-6 col-sm-6 col-xs-12">
                <p class='titulo'><?= Yii::t('app', '¿Deseas cambiar de grupo a un estudiante?') ?></p>
                <p class='observaciones'><?= Yii::t('app', 'Este proceso trasladará al estudiante a otro grupo escolar.') ?></p>
            </div>
        </div> 
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                
                <?= $form->field($model, 'estudiante')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(Tercero::find()->select(['tercero.id', new Expression("CONCAT(primer_nombre,' ', segundo_nombre,' ',primer_apellido,' ',segundo_apellido) as nombre")])->leftjoin('academico', 'academico.estudiante = tercero.id')->Where(['tercero.tipo_tercero' => '1'])->andWhere(['<', 'tercero.estado', '3'])->andWhere(['is not', 'academico.id', null])->orderBy('tercero.primer_apellido')->asArray()->all(), 'id', 'nombre'),
                        'options' => ['placeholder' => Yii::t('app', 'Seleccione el Estudiante')],
                        'hideSearch' => false,
                        'pluginOptions' => [
                            'allowClear' => true,
                        ],
                    ])->label(false);
                ?>
            </div>
        </div>     
        
        <div class="row">
            <div class="col-lg-12 col-md-6 col-sm-6 col-xs-12">
                <p class='titulo'><?= Yii::t('app', '¿A qué grupo deseas trasladar al estudiante?') ?></p>
            </div>
        </div> 

        <div class="row">
            <div class="col-lg-8 col-md-8 col-sm-8 col-xs-12">
                
                <?= $form->field($model, 'grupo_new')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(Grupo::find()->select(['id', new Expression("grupo as nombre")])->Where(['eliminado_por' => '0'])->andWhere(['estado' => '1'])->asArray()->all(), 'id', 'nombre'),
                        'options' => ['placeholder' => Yii::t('app', 'Seleccione el nuevo grupo')],
                        'hideSearch' => false,
                        'pluginOptions' => [
                            'allowClear' => true,
                        ],
                    ])->label(false);
                ?>

                <?= $form->field($model, 'grupo_old')->hiddenInput()->label(false) ?>
            </div>
            <div id="aplicar" class="col-lg-4 col-md-4 col-sm-4 col-xs-12">
                <?= Html::Button(Yii::t('app', 'Cambiar Grupo'), ['id' => 'Btnaplicar','class' => 'btn btn-danger btn-block', 'disabled' => true]); ?>
            </div>
        </div>  

        <div class="row" style="margin-top: 20px; text-align:center;">
            <div class="col-lg-2 col-md-2 col-sm-2 col-xs-2" style="text-align:center;">
                 <h1><span id="actual" class="label label-default"><?= Yii::t('app', 'Actual'); ?></span></h1>
            </div>
            <div class="col-lg-2 col-md-2 col-sm-2 col-xs-2" style="text-align:center;">
                 <h1><i class="fa fa-arrow-right text-success" aria-hidden="true"></i></h1>
            </div>
            <div class="col-lg-2 col-md-2 col-sm-2 col-xs-2" style="text-align:center;">
                 <h1><span id="nuevo" class="label label-default"><?= Yii::t('app', 'Nuevo'); ?></span></h1>
            </div>
        </div>

        <div class="row" style="margin-top: 20px;">
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                <?php
                    echo Progress::widget([
                        'percent' => 0,
                        'barOptions' => ['class' => 'progress-bar-info',],
                        'options' => ['id' => 'progBar', 'class' => 'active progress-striped', 'style' => 'display: none;']
                    ]);
                ?>
            </div>
        </div>

        <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">      

                    <ul class='list-group'>
                        <li class='list-group-item active'><?= Yii::t('app', 'Información del estudiante a procesar...'); ?></li>

                            <li class='list-group-item'>
                                <?= Yii::t('app', 'Registros de Asistencias'); ?>
                                <div id='asistencia' style='float:right;'><i class='fas fa-clock text-info'></i></div>
                            </li>
                            <li class='list-group-item'>
                                <?= Yii::t('app', 'Registros de Calificaciones'); ?>
                                <div id='calificaciones' style='float:right;'><i class='fas fa-clock text-info'></i></div>
                            </li>
                    </ul>
                    
                </div>
            </div>
        </div>

        
    </div>     
</div>

        
        
      


<?

$this->registerJs("

$(document).ready(function() {
    
    $('#aplicar').click(function() {
        tercero = $('#academico-estudiante').val();
        grupo_new = $('#academico-grupo_new').val();
        grupo_old = $('#academico-grupo_old').val();
        

        $('#progBar').slideDown().show();
        $('.progress-bar')[0].style.width = 0;

        $('#mensaje').html(\"<h4 class='text-success'><i class='fa fa-clock'></i> Estamos trabajando en ello.</h4> \");

        $.ajax({
            type: 'GET',
            url: '". Url::to(['calificacion/cambiargrupo'])."',
            timeout: 20000,

            data: {tercero : tercero, grupo_new : grupo_new, grupo_old : grupo_old},
            success: function (data) {
                
                
                $('.progress-bar').css(\"width\", parseInt($('.progress-bar')[0].style.width) + 100 + \"%\");
                    
                if(parseInt($('.progress-bar')[0].style.width) >= 100)
                {
                    $('.progress-bar').toggleClass(\"progress-bar-info \" + \"progress-bar-success\");    
                } 

                $('#mensaje').html(\"<h4 class='text-success'><i class='fa fa-clock'></i> Se ha configurado el \"+ data + \"</h4> \");   
                //window.location.reload();
                
            },
            error: function(request, status, err) {
                if (status == 'timeout') {
                    //timeout -> reload the page and try again
                        //$('#'+valor).html(\"<i class='fas fa-times text-danger'></i>\");
                    console.log('timeout');
                    //window.location.reload();
                } else {
                        //$('#'+valor).html(\"<span class='text-danger'>\"+ err + \"</span>\");
                    //another error occured  
                    //alert('error: ' + request + status + err);
                    console.log('error: ' + request + status + err);
                }
            }
    
        });        
    });

});

");

?>


<script type="text/javascript">
    setTimeout(function() {
        $("#flow_tabs").find("li.active a").click();
    },10)
</script>