<?php

use yii\helpers\Html;
use yii\helpers\ArrayHelper;
use edofre\fullcalendarscheduler\FullcalendarScheduler;

$this->title = 'Agenda';
$this->params['breadcrumbs'][] = $this->title;

$hoy = new DateTime('now', new DateTimeZone('America/Bogota'));

/*
$this->registerCss("
    .fc-button {
        font-weight: 400;
        color: #212529;
        text-align: center;
        vertical-align: middle;
        padding: .4em .65em !important;
        height: auto !important;
        font-size: 1em;
        line-height: 1.5;
        
    }
    .fc-state-default {
        color: #fff;
        background-color: #2c3e50;
        border-color: #2c3e50;
        background-image:none !important;
        text-shadow:none !important;
        box-shadow:none !important;
    }
    .fc-state-default:hover {
        color: #fff;
        background-color: #1e2b37;
        border-color: #1a252f;
    }
    .fc-state-active {
        color: #fff;
        background-color: #1a252f;
        border-color: #151e27;
    }
    .fc-toolbar h2 {
        font-size: 1.75em;
        margin: 0;
    }

");
*/

?>


<div class="site">

    <div class="row">
        <div class="col-lg-12">
            <?= FullcalendarScheduler::widget([
                    'header'        => [
                        'left'   => 'prev,next, today ',
                        'center' => 'title',
                        //'right'  => 'timelineDay,timelineThreeDays,agendaWeek,month',
                        //'right'  => 'timelineDay,agendaWeek,month',
                    ],
                    'clientOptions' => [
                        'schedulerLicenseKey' => 'GPL-My-Project-Is-Open-Source',
                        //'eventLimit'  => true, // allow "more" link when too many events
                        'aspectRatio'       => 1.8,
                        'scrollTime'        => '00:00', // undo default 6am scrollTime
                        'defaultView'       => 'month',
                        'resourceLabelText' => 'Eventos',
                        'resourceAreaWidth' => '20%',
                        'nowIndicator'      => true,
                        'weekends'          => true,
                        'timeFormat'        => 'h(:mm) a',
                        'axisFormat'        => 'h(:mm) a',
                        'slotLabelFormat'        => 'h(:mm) a',
                        'allDaySlot' => false,

                        'resources'         => \yii\helpers\Url::to(['agenda/resources', 'id' => 1]),
                        'events'            => \yii\helpers\Url::to(['agenda/events', 'id' => 2]),
                    ],
                ]);
            ?>  
        </div>
    </div>

</div>





