<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
use kartik\widgets\FileInput;

use backend\models\Tercero;
use backend\models\Tipotercero;
use backend\models\Grupo;
use backend\models\Academico;
use yii\db\Expression;

?>

<div class="anexo-form">

    <div class="row">                
        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    
                    <div class="id-1519">
                        <h4>Documentos Anexos</h4>
                    </div>
                    <div class="bar-line"></div>
                    
                    <ul class="list-group">
                        <?php 


                            if(count($anexos) == 0)
                            {
                                echo '<li class="list-group-item d-flex justify-content-between align-items-center"> Aún no hay documentos anexos</li>';   
                            }

                            foreach ($anexos as $anexo)
                            {
                                echo '<li class="list-group-item d-flex justify-content-between align-items-center">';
                                $carpeta = "/uploads/oferentes/".$anexo->oferentes->id;
                                echo Html::a($anexo->tipos->tipo, $carpeta.'/'.$anexo->anexo, ['target' => '_blank', 'style' => '']);
                                echo Html::a('<i class="fa fa-trash"></i>', ['delete', 'id' => $anexo->id], ['class' => 'btn btn-danger btn-xs', 'data' => ['confirm' => 'Estas seguro de eliminar este registro?', 'method' => 'post'], 'style' => 'float: right;','title'=>'Eliminar']);
                                echo '</li>';
                            }
                        ?>
                    </ul>
                </div>
            </div>
        </div>
        <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">


            <?php $form = ActiveForm::begin([
                    'validateOnSubmit' => true,
                    'enableAjaxValidation' => true,
                    'type' => ActiveForm::TYPE_VERTICAL,
                    'options' => ['class' => 'main-task-form',
                                    'id' => 'formulario',
                                ]
                ]); ?>
            

            <?= $form->field($model, 'id', ['template' => '{input}'])->textInput(['style' => 'display:none']); ?>
            <? 
                $model->oferente = $oferente->id; 
                $model->estado = '1'; 
            ?>
            <?= $form->field($model, 'oferente', ['template' => '{input}'])->textInput(['style' => 'display:none']); ?>
            <?= $form->field($model, 'estado', ['template' => '{input}'])->textInput(['style' => 'display:none']); ?>
                
            <div class="row">                
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">

                    <?= $form->errorSummary($model); ?>
                </div>
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <?= $form->field($model, 'tipo_anexo')->widget(\kartik\widgets\Select2::classname(), [
                        'data' => \yii\helpers\ArrayHelper::map(\backend\models\Tipoanexo::find()->orderBy('id')->asArray()->all(), 'id', 'tipo'),
                        'options' => ['placeholder' => Yii::t('app', 'Seleccione el Tipo de Anexo')],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]); ?>
                </div>
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <?= $form->field($model, 'anexo')->widget(FileInput::classname(), [
                        'options' => ['multiple'=>false,],
                        'pluginOptions'=>[
                            'allowedFileExtensions'=>['pdf'],
                            'hideThumbnailContent' => false,
                            'dropZoneEnabled' => false,
                            'previewFileType' => false,
                            'showUpload' => false,
                            'initialPreview' => [],
                            'overwriteInitial' => false,
                            'browseClass' => 'btn btn-sm btn-primary',
                            'uploadClass' => 'btn btn-sm btn-success',
                            'removeClass' => 'btn btn-sm btn-danger',
                            'cancelClass' => 'btn btn-sm btn-default',
                            ],
                    ]); ?>
                </div>
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                        <?= Html::submitButton(Yii::t('app', 'Agregar'), ['class' => 'btn btn-primary']) ?>
                </div>

                <?php ActiveForm::end(); ?>
            </div>
        </div>
    </div>
</div>
