<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
use yii\web\JsExpression;
use kartik\switchinput\SwitchInput;
use kartik\widgets\DatePicker;
use kartik\widgets\Select2;
use kartik\widgets\DepDrop;
use kartik\widgets\FileInput;
use yii2mod\google\maps\markers\GoogleMaps;
use yii\widgets\ListView;


use frontend\models\Tercero;
use backend\models\Tipotercero;
use backend\models\Tipodocumento;
use backend\models\Genero;
use backend\models\Parentesco;
use backend\models\Pais;
use backend\models\Departamento;
use backend\models\Municipio;
use backend\models\Barrio;
use backend\models\Rh;
use backend\models\Religion;
use backend\models\Etnia;
use backend\models\Eps;
use backend\models\Terceroestado;
use backend\models\Resguardo;
use backend\models\Academico;


$this->title = $model->categoria;

$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Gestión Documental'), 'url' => ['categorias']];

if($model->padres)
{
  $this->params['breadcrumbs'][] = ['label' => $model->padres->categoria, 'url' => ['categoria', 'id' => $model->padres->id]];  
}


//$this->params['breadcrumbs'][] = ['label' => $model->categoria, 'url' => ['index']];

$this->params['breadcrumbs'][] = $this->title;


$this->params['actions'][] = ['label' => 'Buscar', 'url' => false, 'icon' => '<i class="far fa-search"></i>', 'class' => 'primary search-button', 'id' => 'enviar'];
$this->params['actions'][] = ['label' => 'Nuevo', 'url' => 'create', 'icon' => '<i class="far fa-plus"></i>', 'class' => 'success'];
$this->params['actions'][] = ['label' => 'Listar', 'url' => 'index', 'icon' => '<i class="far fa-bars"></i>', 'class' => 'purple'];
$this->params['actions'][] = ['label' => 'Imprimir', 'url' => 'imprimir', 'icon' => '<i class="far fa-print"></i>', 'class' => 'default'];


$this->registerCss('

div.pdtop, #phoca-dl-category-box .pd-category div.pdtop, #phoca-dl-file-box .pd-file div.pdtop, #phoca-dl-download-box .pd-file div.pdtop {
  float: right;
  position: relative;
  width: 16px;
  margin-top: 5px;
  margin-right: 7px;
}

#phoca-dl-category-box .pd-category div.pdtop, #phoca-dl-file-box .pd-file div.pdtop, #phoca-dl-download-box .pd-file div.pdtop {
  float: right;
  position: relative;
  width: 16px;
  margin-top: 5px;
  margin-right: 7px;
  padding-top: 2px;
}

#phoca-dl-categories-box a img, #phoca-dl-category-box a img, #phoca-dl-file-box a img, #phoca-dl-download-box a img {
  border: none;
}

#phoca-dl-category-box .pd-category h3.pd-ctitle, #phoca-dl-file-box .pd-file h3.pd-ctitle, #phoca-dl-download-box .pd-file h3.pd-ctitle {
  margin: 0;
  padding: 5px;
  background: #fafafa;
  border: 1px solid #e9e9e9;
  margin-bottom: 7px;
}

#phoca-dl-categories-box .pd-subcategory, #phoca-dl-category-box .pd-subcategory {
  padding-left: 20px;
  /*background: transparent url("../images/folder.png") 0 center no-repeat;*/

}

#phoca-dl-category-box .pd-subcategory, #phoca-dl-file-box .pd-file {
  margin: 5px;
}


#phoca-dl-category-box .pd-filebox {
  margin-top: 10px;
  margin-bottom: 10px;
  padding-bottom: 10px;
  border-bottom: 1px solid #f0f0f0;
}

#phoca-dl-download-box .pd-filenamebox, #phoca-dl-category-box .pd-filenamebox {
  position: relative;
  float: left;
  margin: 5px;
}

.phoca-dl-file-box-mod .pd-document32, #phoca-dl-file-box .pd-document32, #phoca-dl-category-box .pd-document32, #phoca-dl-most-viewed-box .pd-document32, #phoca-dl-download-box .pd-document32 {
  background: url("../../images/icon-document-32.png") 0px center no-repeat;
  height: 32px;
  line-height: 32px;
  padding-left: 36px;
}

.pd-float {
  position: relative;
  float: left;
  margin: 0px 3px;
  font-weight: bold;
}

.phoca-dl-file-box-mod .pd-document32, #phoca-dl-file-box .pd-document32, #phoca-dl-category-box .pd-document32, #phoca-dl-most-viewed-box .pd-document32, #phoca-dl-download-box .pd-document32 {
  line-height: 32px;
}

#phoca-dl-category-box .pd-buttons, #phoca-dl-file-box .pd-buttons, #phoca-dl-download-box .pd-buttons {
  position: relative;
  float: right;
  margin: 5px;
}

#overDiv .pd-fdesc, #phoca-dl-category-box .pd-fdesc, #phoca-dl-file-box .pd-fdesc, #phoca-dl-download-box .pd-fdesc {
  padding: 5px 0px;
  clear: both;
}


');


$search = "$('.search-button').click(function(){
  $('.search-form').toggle(1000);
  return false;
});";

$this->registerJs($search);

?>


    
<div class="row">
    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        
        <div style ="float:right;">
          <?= Html::a('<i class="fa fa-search" aria-hidden="true"></i>', '#', ['class' => 'btn-floating btn-large search-button']) ?>
        </div>
        

        <div class="search-form" style="display:<?= Yii::$app->request->get('DocumentoSearch') ? 'block' : 'none'; ?>">
            <?=  $this->render('_search', ['model' => $searchModel]); ?>
        </div>

        <blockquote>

          <?php 
            if($model->padre)
            {
          
              echo '<div class="pdtop">'.Html::a('<i class="fa fa-arrow-up" aria-hidden="true"></i>', ['categoria', 'id' => $model->padre], ['class' => '', 'data-toggle' => 'tooltip', 'title' => 'Subir', 'target' => '_self']).'</div>';
            }
          ?>
              <h3><?= $model->categoria ?></h3>
              <?= $model->descripcion ?>

              <?php
                foreach ($model->subcategorias as $categoria) {
              ?>

                  
                  <h5>
                    <?= Html::a('<i class="fa fa-folder" aria-hidden="true"></i> '.$categoria->categoria, ['categoria', 'id' => $categoria->id], ['class' => '', 'data-toggle' => 'tooltip', 'title' => $categoria->categoria, 'target' => '_self']) ?>
                  </h5>
                                
              <?php
                  }
              ?>
        </blockquote>

        



        <div id="phoca-dl-category-box" class="pd-category-view">
          <div class="pd-category">

            
            
            <div class="pd-cb"></div>
              
              <?= ListView::widget([
                  'dataProvider' => $dataProvider,   
                  //'layout' => "{items}\n{pager}\n{summary}",
                  'viewParams' => [],
                  'itemView' => '_list_documentos',
                  'options' => [
                  ],
                  'itemOptions' => [
                      'tag' => false,
                  ],
                  'summary'=>'',
              ]) ?>            

          </div>
        </div>

    </div>   
</div>