<?php

/* @var $this \yii\web\View */
/* @var $content string */
use yii\helpers\Html;
use yii\helpers\Url;
use yii\bootstrap\Nav;
use yii\bootstrap\NavBar;
use yii\widgets\Breadcrumbs;
use kartik\tabs\TabsX;
use yii\bootstrap\Modal;
use kartik\widgets\ActiveForm;
use kartik\widgets\Select2;
use yii\db\Expression;
use yii\helpers\ArrayHelper;
use yii\web\JsExpression;


use frontend\assets\AppAsset;

use frontend\models\BuscarForm;
use backend\models\Blog;
use backend\models\Menuweb;
use backend\models\Sede;
use backend\models\Agenda;
use backend\models\Slide;
use backend\models\Enlace;
use backend\models\Documentocategoria;

use common\widgets\Alert;

//use kartik\alert\AlertBlock;
//use yii\widgets\Alert;


$asset = frontend\assets\AppAsset::register($this);
$baseUrl = $asset->baseUrl;

//AppAsset::register($this);
$sede = Sede::find()->where(['principal' => "1"])->one();


if ($sede->sitio_online == '0') {
    echo $this->render(
        'offline',
        ['sede' => $sede]
    );
} else {

$model = new BuscarForm();

?>

<?php $this->beginPage() ?>


<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    
    <link rel="profile" href="http://www.w3.org/1999/xhtml/vocab" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!--[if IE]><![endif]-->


    <meta http-equiv="Content-Type" content="text/html;" charset="<?= Yii::$app->charset ?>">
    <meta name="description" content= "<?= Html::encode($sede->sede) ?>" />
    <meta name="abstract" content= "<?= Html::encode($sede->sede) ?>" />
    <meta name="rating" content="general" />
    <meta name="rights" content="<?= Html::encode($sede->sede) ?>. Todos los derechos reservados" />
    <meta name="generator" content="Sonic - Software de Notas Integrado para Colegios" />


    <!-- Go to www.addthis.com/dashboard to customize your tools --> 
    <!--<script type="text/javascript" src="//s7.addthis.com/js/300/addthis_widget.js#pubid=ra-612f9bf9587ee190"></script> -->

    <link rel="icon" type="image/x-icon" href="<?= Yii::$app->homeUrl ?>images/favicon.ico">    


    <link rel="apple-touch-icon" sizes="180x180" href="<?= $baseUrl?>/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="<?= $baseUrl?>/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="<?= $baseUrl?>/favicon-16x16.png">
    <link rel="manifest" href="<?= $baseUrl?>/site.webmanifest">
    <link rel="mask-icon" href="<?= $baseUrl?>/safari-pinned-tab.svg" color="#5bbad5">
    <meta name="msapplication-TileColor" content="#da532c">
    <meta name="theme-color" content="#ffffff">

    <!--
    <link rel="shortcut icon" href="logo_36.png" type="image/png" />
    --> 

    <title><?= Html::encode($this->title) ?></title>
 
    <!-- inicio -->    
        <?= Html::csrfMetaTags() ?>
    <!-- fin -->
        <?php $this->head() ?>
    <!-- head -->

</head>
<body>
<?php $this->beginBody() ?>

<? Html::img('@web/images/logo.png', ['class'=>'img-responsive']); ?>

    <div class="bg-top navbar-light">
      <div class="container">
        <div class="row no-gutters d-flex align-items-center align-items-stretch">
          <div class="col-md-5 d-flex align-items-center py-4">
            <a class="navbar-brand" href="<?= Yii::$app->homeUrl ?>">
                <? Html::img('@web/images/logo.jpg', ['class'=>'']); ?>
                <?= $sede->sede ?>
                <span><?= $sede->slogan ?></span>
            </a>
          </div>
          <div class="col-lg-7 d-block">
            <div class="row d-flex">
              <div class="col-md d-flex topper align-items-center align-items-stretch py-md-4">
                <div class="icon d-flex justify-content-center align-items-center"><span class="icon-envelope"></span></div>
                <div class="text">
                  <span><?= $sede->rector_email ?></span>
                </div>
              </div>
              <div class="col-md d-flex topper align-items-center align-items-stretch py-md-4">
                <div class="icon d-flex justify-content-center align-items-center"><span class="icon-phone2"></span></div>
                <div class="text">
                  <span><?= $sede->fijo ?></span>
                </div>
              </div>
              <!--<div class="col-md topper d-flex align-items-center justify-content-end">
                <p class="mb-0">
                  <?= Html::a(Yii::$app->user->isGuest ? 'Ingresar' : 'Salir', [Yii::$app->user->isGuest ? 'admin/' : 'site/logout'], ['data-method' => 'post', 'class'=>'btn py-2 px-3 btn-primary d-flex align-items-center justify-content-center']); ?>
                </p>
              </div>-->
            </div>
          </div>
        </div>
      </div>
    </div>
<!--
 <nav id="ftco-navbar" class="navbar navbar-inverse">
  <div class="container-fluid">
    <div class="navbar-header">
      <a class="navbar-brand" href="#">WebSiteName</a>
    </div>
    <ul class="nav navbar-nav">
      <li class="active"><a href="#">Home</a></li>
      <li><a href="#">Page 1</a></li>
      <li><a href="#">Page 2</a></li>
    </ul>
    <ul class="nav navbar-nav navbar-right">
      <li><a href="#"><span class="glyphicon glyphicon-user"></span> Sign Up</a></li>
      <li><a href="#"><span class="glyphicon glyphicon-log-in"></span> Login</a></li>
    </ul>
  </div>
</nav> 

<br>-->

    <!-- NAV START -->
          <!--<nav class="navbar navbar-expand-lg navbar-dark bg-dark ftco-navbar-dark" id="ftco-navbar">-->
          
          <nav class="navbar navbar-expand-lg navbar-dark bg-dark ftco-navbar-dark" id="ftco-navbar">
              
              <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#ftco-nav" aria-controls="ftco-nav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
              </button>

              <div class="collapse navbar-collapse" id="ftco-nav">
                <ul class="navbar-nav mr-auto">
                  <li class="nav-item">
                    <?= Html::a('Inicio', ['site/index'], ['class'=>'nav-link']); ?>
                  </li>

                  <?
                    $menus =  Menuweb::find()->where(['IS', 'padre', new \yii\db\Expression('NULL')])->andWhere(['estado' => '1'])->andWhere(['eliminado_por' => '0'])->orderBy(['orden' => SORT_ASC])->all();

                    foreach ($menus as $menu) 
                    {
                      if($menu->hijos)
                      {
                        echo '<li class="nav-item dropdown">';
                        echo '<a class="nav-link dropdown-toggle" href="#" id="dropdown05" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">'.$menu->nombre.'</a>';
                        echo '<div class="dropdown-menu" aria-labelledby="dropdown05">';
                      ?>
                        
                      <?
                        foreach ($menu->hijos as $hijo) 
                        {
                        
                          //echo Html::a($hijo->nombre, ['site/view', 'id' => $hijo->item], ['class'=>'dropdown-item']);

                          if($hijo->item != NULL)
                          {
                            switch ($hijo->tipo) {
                              case '1': 
                                // CATEGORIA DE ARTÍCULOS
                                echo Html::a($hijo->nombre, ['site/blog', 'categoria' => $hijo->item], ['class'=>'dropdown-item']); 
                                break;

                              case '2':
                                // ARTÍCULO
                                echo Html::a($hijo->nombre, ['site/view', 'id' => $hijo->item], ['class'=>'dropdown-item']);  
                                break;

                              case '3':
                                // CATEGORIA DOCUMENTOS
                                echo Html::a($hijo->nombre, ['documento/categorias'], ['class'=>'dropdown-item']);  
                                break;

                              case '4':
                                // DOCUMENTO
                                echo Html::a($hijo->nombre, ['documento/view', 'id' => $hijo->item], ['class'=>'dropdown-item']); 
                                break;

                              case '5':
                                // ENLACE
                                echo Html::a($hijo->nombre, $hijo->item, ['class'=>'dropdown-item']); 
                                break;

                              case '6':
                                // CONTÁCTO
                                echo Html::a($hijo->nombre, ['site/contacto'], ['class'=>'dropdown-item']); 
                                break;

                              case '7':
                                // PQRSD
                                if($hijo->item == 1)
                                {
                                  // NORMAL
                                  echo Html::a($hijo->nombre, ['pqrsd/create'], ['class'=>'dropdown-item']);
                                }
                                if($hijo->item == 2)
                                {
                                  // NORMAL
                                  echo Html::a($hijo->nombre, ['pqrsd/anonymous'], ['class'=>'dropdown-item']);
                                }
                                if($hijo->item == 3)
                                {
                                  // NORMAL
                                  echo Html::a($menu->nombre, ['pqrsd/index'], ['class'=>'dropdown-item']);
                                }
                                
                                break;

                              case '8':
                                // AGENDA
                                echo Html::a('*'.$menu->nombre, ['agenda'], ['class'=>'dropdown-item']);  
                                break;
                              
                              default:
                                # code...
                                break;
                            }
                            
                          }
                          else
                          {
                            echo Html::a('/'.$menu->nombre, ['#'], ['class'=>'dropdown-item']); 
                          }
                          
                        }

                        echo '</div>';
                        echo '</li>';

                      }
                      else
                      {
                        echo '<li class="nav-item">';
                        
                        if($menu->item != NULL)
                        {
                          switch ($menu->tipo) {
                            case '1': 
                              // CATEGORIA DE ARTÍCULOS
                              echo Html::a($menu->nombre, ['site/blog', 'categoria' => $menu->item], ['class'=>'nav-link']);  
                              break;

                            case '2':
                              // ARTÍCULO
                              echo Html::a($menu->nombre, ['site/view', 'id' => $menu->item], ['class'=>'nav-link']); 
                              break;

                            case '3':
                              // CATEGORIA DOCUMENTOS
                              echo Html::a($menu->nombre, ['documento/categorias'], ['class'=>'nav-link']); 
                              break;

                            case '4':
                              // DOCUMENTO
                              echo Html::a($menu->nombre, ['documento/view', 'id' => $menu->item], ['class'=>'nav-link']);  
                              break;

                            case '5':
                              // ENLACE
                              echo Html::a($menu->nombre, $menu->item, ['class'=>'nav-link']);  
                              break;

                            case '6':
                              // CONTÁCTO
                              echo Html::a($menu->nombre, ['site/contacto'], ['class'=>'nav-link']);  
                              break;

                            case '7':
                              // PQRSD
                              if($menu->item == 1)
                              {
                                // NORMAL
                                echo Html::a($menu->nombre, ['pqrsd/create'], ['class'=>'nav-link']);
                              }
                              if($menu->item == 2)
                              {
                                // NORMAL
                                echo Html::a($menu->nombre, ['pqrsd/anonymous'], ['class'=>'nav-link']);
                              }
                              if($menu->item == 3)
                              {
                                // NORMAL
                                echo Html::a($menu->nombre, ['pqrsd/find'], ['class'=>'nav-link']);
                              }
                              
                              break;

                            case '8':
                                // AGENDA
                                echo Html::a($menu->nombre, ['agenda/'], ['class'=>'nav-link']);  
                                break;
                            
                            default:
                              # code...
                              break;
                          }
                          
                        }
                        else
                        {
                          echo Html::a('>'.$menu->nombre, ['#'], ['class'=>'nav-link']);  
                        }
                        
                        echo '</li>';
                      }
                    
                    }

                  ?>

                        
                        <?php if(!Yii::$app->user->isGuest) { ?>


                        <li class="nav-item dropdown">
                            <? Html::a('Panel', ['site/panel'], ['class'=>'nav-link dropdown-toggle', 'id' => 'dropdown05' , 'data-toggle' => 'dropdown', 'aria-expanded' => 'false']);  ?>
                            <a class="nav-link dropdown-toggle" href="#" id="dropdown05" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Panel</a>
                                <div class="dropdown-menu" aria-labelledby="dropdown05">
                                    <?
                                        echo Html::a('Panel de Usuario', ['site/panel'], ['class'=>'dropdown-item']);  
                                        
                                        if(Yii::$app->session->get('__tercero') == null)
                                        {
                                            echo Html::a('Mis Datos Personales', ['tercero/create'], ['class'=>'dropdown-item']);  
                                        }
                                        else
                                        {
                                            echo Html::a('Mis Datos Personales', ['tercero/update', 'id' => Yii::$app->session->get('__tercero')], ['class'=>'dropdown-item']);
                                        }

                                        
                                    ?>
                                </div>
                        </li>

                        <?php } ?>



                    <li class="nav-item">
                      <?= Html::a(Yii::$app->user->isGuest ? 'Ingresar' : 'Salir', [Yii::$app->user->isGuest ? 'site/login' : 'site/logout'], ['data-method' => 'post', 'class'=>'nav-link']); ?>
                    </li> 

                </ul>
                
                <? Html::a(Yii::$app->user->isGuest ? 'Ingresar' : 'Salir', [Yii::$app->user->isGuest ? 'admin/' : 'site/logout'], ['data-method' => 'post', 'class'=>'btn py-2 px-3 btn-primary d-flex align-items-center justify-content-center']); ?>
                
                <!--
                <ul class="nav navbar-nav navbar-right">
                  <li class="active">
                    <?= Html::a(Yii::$app->user->isGuest ? 'Ingresar' : 'Salir', [Yii::$app->user->isGuest ? 'admin/' : 'site/logout'], ['data-method' => 'post', 'class'=>'btn py-2 px-3 btn-primary d-flex align-items-center justify-content-center']); ?>
                  </li>
                </ul>
                -->
                  <ul class="nav navbar-nav navbar-right">
                      <li><a href="#"><span class="glyphicon glyphicon-user"></span> Sign Up</a></li>
                      <li><a href="#"><span class="glyphicon glyphicon-log-in"></span> Login</a></li>
                  </ul>
              </div>
          </nav>
          <!-- END nav -->


<!--
    <section class="hero-wrap hero-wrap-2" style="background-image: url('<?= Yii::$app->homeUrl ?>images/bg_<?= rand(1, 5)?>.jpg');">
      <div class="overlay"></div>
      <div class="container">
        <div class="row no-gutters slider-text align-items-center justify-content-center">
          <div class="col-md-9 ftco-animate text-center">
            <h1 class="mb-2 bread"><?= Html::encode($this->title) ?></h1>
          </div>
        </div>
      </div>
    </section>
-->


          <?php if((Yii::$app->controller->id == 'site') and (Yii::$app->controller->action->id == 'index')) { ?> 

            <?php


              $slides = Slide::find()->where(['estado' => '1'])->all();

              if($slides)
              {
                
            ?>

                <div class="home-slider owl-carousel owl-theme">
                 

                  <?

                    $x = 0;
                    foreach ($slides as $slide) 
                    {
                     

                      echo '<div class="item">';
                      
                          
                      if($slide->enlace)
                      {
                        echo '<a href="'.$slide->enlace.'">'; 
                      }

                      if($slide->tipo == 1)
                      {
                        echo Html::img('@web/images/slide/'.$slide->imagen, ['id' => '', 'class'=>'', 'style' => '']);
                      }
                      else
                      {
                        echo '<div class="video-responsive">'.$slide->video.'</div>';
                      }
                        
                      
                      if($slide->enlace)
                      {
                        echo '</a>';
                      }

                      echo "</div>";

                    }

                  ?>

                </div>


              
              <?php } } else { if(isset($this->params['breadcrumbs'])) { ?>
              <!--
                  <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                      <li class="breadcrumb-item"><a href="#">Home</a></li>
                      <li class="breadcrumb-item"><a href="#">Library</a></li>
                      <li class="breadcrumb-item active" aria-current="page">Data</li>
                    </ol>
                  </nav>
                  <i class='fa fa-angle-double-right' aria-hidden='true'></i>
              --> 

                      <div class="breadcrumb">
                    <?= Breadcrumbs::widget([
                        'homeLink' => [
                            'label' => 'Inicio',
                            'url' => Url::home(),
                            'template' => "<li class=\"breadcrumb-item\">{link}</li>\n"
                        ],
                                //'options' => ['class' => 'hidden-sm hidden-xs'], 
                                'activeItemTemplate' => "<li class=\"breadcrumb-item active\" aria-current=\"page\">{link}</li>\n",  
                                'itemTemplate' => "<li class = 'breadcrumb-item'>{link}</li>\n",  
                                'links' => isset($this->params['breadcrumbs']) ? $this->params['breadcrumbs'] : [],
                             ]); 
                        ?>
                      </div>
                          
              <?php }} ?>  
        
        
    <section class="ftco-section bg-light">
      <div class="container">
            <?= Alert::widget(); ?>
            <?= $content ?>
      </div>
    </section>
    

 <div class="id-1519">
    <h2>Centro de Gestión Documental</h2>
</div>

<div class="bar-line"></div>

<div class="hspace"></div>

    <?php

        $categorias = Documentocategoria::find()->where(['IS', 'padre',  new \yii\db\Expression('NULL')])->andWhere(['estado' => '1'])->all();

        if($categorias)
        {
    ?>

            <?php

                $x = 1;
                foreach ($categorias as $categoria) 
                {
                
            ?>
            <div class="col-lg-2 col-md-2 col-sm-2 col-xs-12">
                <div class="canal-h">
                    <div class="m20-icon-c">
                        <a href="<?= Url::to(['documento/categoria', 'id' => $categoria->id]) ?>" target="_self">
                            <img src="https://www.concejodevillavicencio.gov.co/images/servicios/5.jpeg">
                        </a>

                    </div>

                    <div class="canal-infoh">
                        <h4>
                            <a href="<?= Url::to(['documento/categoria', 'id' => $categoria->id]) ?>" target="_self">
                                <?= $categoria->categoria ?>
                            </a>
                        </h4>
                        <p><?= $categoria->descripcion ?></p>
                    </div>
                </div>
            </div>
            
            <?php 
                } 

        }
    ?>

<!-- FIN DE CATEGORÍAS DE DESCARGAS -->


<div class="hspace"></div>

<div class="wcenter">
    <a href="<?= Url::to(['documento/categorias']) ?>" target="_self" title="clic para consultar todas las categorías" class="btn-1519-1">
        Consultar más categorías
    </a>
</div>





    <footer class="ftco-footer ftco-bg-dark ftco-section">
      <div class="container">
        <div class="row">
          <div class="col-md-12 col-lg-12">
            <div class="ftco-footer-widget mb-5">
              <h2 class="ftco-heading-2">Ubíquenos</h2>
              <div class="block-23 mb-3">
                <ul>
                  <li><span class="icon icon-map-marker"></span><span class="text"><?= $sede->direccion ?></span></li>
                  <li><span class="icon icon-phone"></span><span class="text"><?= $sede->fijo ?></span></li>
                  <li><span class="icon icon-envelope"></span><span class="text"><?= $sede->rector_email ?></span></li>
                  <li><span class="icon icon-envelope"></span><span class="text">Nit. <?= $sede->nit ?></span></li>
                </ul>
              </div>
            </div>
          </div>          
        </div>
        <div class="row">
            <p style="padding-left: 20px; font-size: 14px; color: #fff; font-weight: 500;">SONIC <span style="font-size: 14px; color: #ffc107;">Software de Notas Integrado para Colegios</span></p>
            &nbsp;&nbsp;
            <p style="padding-left: 20px;">Copyright &copy; <script>document.write(new Date().getFullYear());</script> Todos los derechos reservados.</p>
        </div>
      </div>
    </footer>


  <!-- loader -->
  <div id="ftco-loader" class="show fullscreen"><svg class="circular" width="48px" height="48px"><circle class="path-bg" cx="24" cy="24" r="22" fill="none" stroke-width="4" stroke="#eeeeee"/><circle class="path" cx="24" cy="24" r="22" fill="none" stroke-width="4" stroke-miterlimit="10" stroke="#F96D00"/></svg></div>




<?php
    
    Modal::begin([
        'headerOptions' => ['id' => 'modalHeader'],
        'id' => 'modal',
        'header' => 'Sonic',
        'size' => 'modal-lg',
        
        //keeps from closing modal with esc key or by clicking out of the modal.
        // user must click cancel or X to close
        'clientOptions' => ['backdrop' => 'static', 'keyboard' => TRUE, 'show' => FALSE,]
    ]);
?>    
    <div id='modalContent'>
        <div style='text-align:center;'>
            <img src='<?= Url::to('@web/images/loading.gif')?>' width='50px' height='50px'>
        </div>
    </div>
<?php    
    yii\bootstrap\Modal::end();
?>


<?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage(); } ?>
