<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use kartik\switchinput\SwitchInput;
use kartik\widgets\ColorInput;
use kartik\widgets\DateTimePicker;
use kartik\widgets\Select2;
use kartik\widgets\FileInput;
use kartik\widgets\TouchSpin;
use dosamigos\tinymce\TinyMce;

$this->registerCss("
    .tox .tox-editor-header
    {
        z-index: 0 !important;
    }
");

?>

<?php $form = ActiveForm::begin([
    //'validateOnSubmit' => true,
    'type' => ActiveForm::TYPE_VERTICAL,
    'options' => ['class' => 'main-task-form',
                  'id' => 'formulario',
                  'enctype'=>'multipart/form-data',
                ]
]); ?>

<div class="enlace-form">

<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> Información del PQRSD</h3>
    </div>

    <div class="panel-body" >

        <?= $form->errorSummary($model); ?>

        <?= $form->field($model, 'id', ['template' => '{input}'])->textInput(['style' => 'display:none']); ?>
        
    <div class="col-sm-6">     

        <?= $form->field($model, 'tipo')->widget(\kartik\widgets\Select2::classname(), [
            'data' => \yii\helpers\ArrayHelper::map(\backend\models\Tipopqrsd::find()->orderBy('id')->asArray()->all(), 'id', 'tipo'),
            'options' => ['placeholder' => Yii::t('app', 'Seleccione Tipo')],
            'pluginOptions' => [
                'allowClear' => true
            ],
        ]); ?>
    </div>

    <div style="clear:both;"></div>

    <div class="col-sm-6">     

        <?= $form->field($model, 'asunto')->textInput(['maxlength' => true, 'placeholder' => 'Asunto']) ?>
    </div>      

    <div class="col-sm-6">     
        <?= $form->field($model, 'email')->textInput(['maxlength' => true, 'placeholder' => 'Correo Electrónico']) ?>
    </div>       


    <div class="col-sm-12">     

        <?= $form->field($model, 'mensaje')->widget(TinyMce::className(), [
            'options' => ['rows' => 15],
            'language' => 'es',
            /*'clientOptions' => [
                'plugins' => [
                    "advlist autolink lists link charmap print preview anchor",
                    "searchreplace visualblocks code fullscreen",
                    "insertdatetime media image table contextmenu paste"
                ],
                'toolbar' => "undo redo | copy cut paste pastetext | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link media table image",
            ]*/
        ])->label();?>

    </div>
    
    <div class="col-sm-12">

        <?= $form->field($model, 'adjunto_solicitud[]')->widget(FileInput::classname(), [
            'options' => ['multiple'=>true],
            'pluginOptions'=>[
                //'uploadUrl' => Url::to(['/site/file-upload']),
                //'allowedFileExtensions'=>['pdf'],
                //'previewFileType' => 'any',
                'showUpload' => false,
                'overwriteInitial' => false,
                'browseClass' => 'btn btn-primary',
                'uploadClass' => 'btn btn-success',
                'removeClass' => 'btn btn-danger',
                'removeIcon' => '<i class="glyphicon glyphicon-trash"></i>',
                ],
        ])->label('Adjuntos:'); ?>
    </div>       
   


    <div class="col-sm-3">
        <?= Html::submitButton('Enviar', ['class' => 'btn btn-primary']) ?>
    </div>


    </div>
</div>

    <?php ActiveForm::end(); ?>

</div>