<?php 

use yii\helpers\Html;
use kartik\grid\GridView;
use kartik\dynagrid\DynaGrid;

/* @var $searchModel backend\models\MunicipioSearch */


$this->title = 'PQRSD';
$this->params['breadcrumbs'][] = $this->title;

$this->params['actions'][] = ['label' => 'Buscar', 'url' => false, 'icon' => '<i class="far fa-search"></i>', 'class' => 'primary search-button', 'id' => 'enviar'];
$this->params['actions'][] = ['label' => 'Nuevo', 'url' => 'create', 'icon' => '<i class="far fa-plus"></i>', 'class' => 'success'];
$this->params['actions'][] = ['label' => 'Listar', 'url' => 'index', 'icon' => '<i class="far fa-bars"></i>', 'class' => 'purple'];
$this->params['actions'][] = ['label' => 'Imprimir', 'url' => 'imprimir', 'icon' => '<i class="far fa-print"></i>', 'class' => 'default'];


$search = "$('.search-button').click(function(){
    $('.search-form').toggle(1000);
    return false;
});";
$this->registerJs($search);
?>
<div class="pqrsd-index" style="clear:both;"></div>

    <div class="search-form" style="display:none">
        <?=  $this->render('_search', ['model' => $searchModel]); ?>
    </div>
    <?php 
    $gridColumn = [
        ['class' => 'yii\grid\SerialColumn'],
        ['attribute' => 'id', 'visible' => true],
        [
            'attribute' => 'tipo',
            'label' => Yii::t('app', 'Tipo'),
            'value' => function($model){
                if ($model->tipos)
                {
                    
                    return "<span class='badge' style='background-color: {$model->tipos->color}'> </span>  <code>" . $model->tipos->tipo . '</code>';
                }
                else
                {return NULL;}
            },
            'vAlign' => 'middle',
            'format' => 'raw',
            'filterType' => GridView::FILTER_SELECT2,
            'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Tipopqrsd::find()->asArray()->all(), 'id', 'tipo'),
            'filterWidgetOptions' => [
                'pluginOptions' => ['allowClear' => true],
            ],
            'filterInputOptions' => ['placeholder' => 'Tipo', 'id' => 'grid-pqrsd-search-tipo']
        ],
        [
            'attribute' => 'asunto',
            'label' => Yii::t('app', 'Asunto'),
            'value' => function($model){
                    return Html::a($model->asunto, ['pqrsd/view', 'id' => $model->id]);
            },
            'vAlign' => 'middle',
            'format' => 'raw',
        ],

        'asunto',
        
        'creado_el',
        [
            'class'=>'kartik\grid\BooleanColumn',
            'attribute'=>'estado', 
            'vAlign'=>'middle'
        ],
        
    ]; 
    ?>


<?
    $dynagrid = DynaGrid::begin([
        'columns'=> $gridColumn,
        'theme'=>'panel-default',
        'showPersonalize'=>true,
        'storage'=>DynaGrid::TYPE_DB,
        'gridOptions'=>[
            'dataProvider'=>$dataProvider,
            'filterModel'=>$searchModel,
            'showPageSummary'=>false,
            'floatHeader'=>false,
            'pjax'=> true,
            'panel'=>[
                'heading'=>'<i class="fa fa-users"></i>  Mis PQRSD',
                'before' =>  '<em></em>',
                //'after' => '{summary}',
                //'footer'=> '{summary}',
            ],        
            
            /*'toolbar' =>  [
                ['content'=>
                    Html::a('<i class="fa fa-plus"></i>', ['create'], ['data-pjax'=>0, 'class' => 'btn btn-success', 'title'=>'Crear']) . ' '.
                    Html::a('<i class="fa fa-repeat"></i>', ['index'], ['data-pjax'=>0, 'class' => 'btn btn-default', 'title'=>'Volver a Cargar'])
                ],
                ['content'=>'{dynagridFilter}{dynagridSort}{dynagrid}{export}{toggleData}'],
                
            ],*/
        ],
        'options'=>['id'=>'pqrsd'] // a unique identifier is important
    ]);
    

    DynaGrid::end();
?>
</div>
