<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Pqrsd */

$this->title = strtoupper(Yii::t('app', 'Pqrsd').' '.$model->id);
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Pqrsd'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="pqrsd-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= strtoupper(Yii::t('app', 'Pqrsd').' '. Html::encode($model->id)) ?></h2>
        </div>
        <div class="col-sm-3" style="margin-top: 15px">
            
            <? Html::a(Yii::t('app', 'Update'), ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>


            <?= Html::a(Yii::t('app', 'Eliminar'), ['delete', 'id' => $model->id], [
                'class' => 'btn-1519-2',
                'data' => [
                    'confirm' => Yii::t('app', 'Estás seguro de eliminar esta PQRSD?'),
                    'method' => 'post',
                ],
            ])
            ?>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        ['attribute' => 'id', 'visible' => false],
        /*[
            'attribute' => 'terceros.nombre',
            'label' => Yii::t('app', 'Tercero'),
        ],*/
        'asunto',
        [
            'attribute' => 'tipos.tipo',
            'label' => Yii::t('app', 'Tipo'),
        ],
        [
            'attribute' => 'mensaje',
            'label' => Yii::t('app', 'Mensaje'),

            'format' => 'raw',
        ],
        [
            'attribute' => 'adjunto_solicitud',
            'label' => Yii::t('app', 'Adjunto de la Solicitud'),
            'format' => 'raw',
            'value' => function($model){
            
                if ($model->adjunto_solicitud)
                {
                    
                    $adjuntos = explode(',', $model->adjunto_solicitud); 
                    //$adjuntos_cantidad = count($adjuntos);

                    $html ='';

                    foreach ($adjuntos as $adjunto) 
                    { 
                        $archivo = unserialize($adjunto);
                        
                        $html .= '<a href="https://drive.google.com/open?id='.$archivo['id'].'" target="_blank">';
                        $html .= '<i class="fas fa-link text-primary"></i>&nbsp;'.$archivo["file"].'</a><br>';
                    }
                    
                    return $html;
                }
                else
                {
                    return '<i class="fas fa-unlink text-danger"></i>';
                }
            }
        ],
        [
            'attribute' => 'respuesta',
            'label' => Yii::t('app', 'Respuesta'),

            'format' => 'raw',
        ],
        [
            'attribute' => 'adjunto_respuesta',
            'label' => Yii::t('app', 'Adjunto de la Respuesta'),
            'format' => 'raw',
            'value' => function($model){
                return Html::a($model->adjunto_respuesta);
            }
        ],
        //'visto',
        //'visto_el',
        [
            'attribute'=>'estado', 
            'vAlign'=>'middle',
            'format' => 'raw',
            'value' => function($model){
                if ($model->estado==1)
                {
                    return '<span class="label label-success">Resuelto</span>';    
                }
                else
                {
                    return '<span class="label label-danger">Sin Resolver</span>';    
                }
                
            }
        ],
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]);
?>
    </div>

</div>
